/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.zhyd.oauth.utils.UuidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class ValidateCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeUtil.class);
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    public static final String PATH_SEPARATOR = "/";
    public static final String CLASS_PATH = "classpath:";
    public static final String OS_KEY = "OS";
    public static final String WINDOWS = "Windows";

    public static String getAbsPath(@NonNull String imageDirectory) {
        try {
            File dirFile = ResourceUtils.getFile((String)imageDirectory);
            return dirFile.getAbsolutePath();
        }
        catch (IOException e) {
            try {
                if (imageDirectory.startsWith(CLASS_PATH)) {
                    URL absClasspathUrl = ResourceUtils.getURL((String)CLASS_PATH);
                    String absClasspath = absClasspathUrl.getPath();
                    if (System.getenv(OS_KEY).startsWith(WINDOWS)) {
                        absClasspath = absClasspath.substring(1);
                    }
                    String correctImageDirectory = imageDirectory.substring(CLASS_PATH.length());
                    Files.createDirectories(Paths.get(absClasspath, correctImageDirectory), new FileAttribute[0]);
                } else {
                    Files.createDirectories(Paths.get(imageDirectory, new String[0]), new FileAttribute[0]);
                }
                return ValidateCodeUtil.getAbsPath(imageDirectory);
            }
            catch (IOException ex) {
                String msg = String.format("\u83b7\u53d6 %s \u7edd\u5bf9\u8def\u5f84\u5931\u8d25: %s", imageDirectory, e.getMessage());
                log.info(msg, (Throwable)ex);
                throw new RuntimeException(msg, ex);
            }
        }
    }

    public static String getFileName(@NonNull String absPath) {
        int lastIndexOf = absPath.lastIndexOf(PATH_SEPARATOR);
        if (lastIndexOf == -1) {
            lastIndexOf = absPath.lastIndexOf(File.separator);
        }
        if (lastIndexOf == -1) {
            return null;
        }
        return absPath.substring(lastIndexOf + 1);
    }

    public static void readFiles2CacheImageCodes(String[] newImagePaths, List<File> fileList) {
        int size = fileList.size();
        int totalImages = newImagePaths.length;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < totalImages; ++i) {
            newImagePaths[i] = i < size ? fileList.get(i).getAbsolutePath() : fileList.get(random.nextInt(size)).getAbsolutePath();
        }
    }

    public static String getImageAbsPath(@NonNull String[] imageCodePaths) {
        int index = ThreadLocalRandom.current().nextInt(imageCodePaths.length);
        String imageCodePath = imageCodePaths[index];
        if (StringUtils.hasText((String)imageCodePath)) {
            return imageCodePath;
        }
        return ValidateCodeUtil.getImageAbsPath(imageCodePaths);
    }

    public static String getRandomImageAbsPath(@NonNull String imageDirectory) {
        try {
            String[] fileNames;
            File dirFile = ResourceUtils.getFile((String)imageDirectory);
            if (dirFile.isDirectory() && (fileNames = dirFile.list()) != null) {
                int r = ThreadLocalRandom.current().nextInt(fileNames.length);
                return String.format("%s%s%s", dirFile.getPath(), PATH_SEPARATOR, fileNames[r]);
            }
        }
        catch (FileNotFoundException e) {
            log.info(String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u8def\u5f84: %s", imageDirectory), (Throwable)e);
        }
        log.info("\u751f\u6210\u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u8def\u5f84: {}", (Object)imageDirectory);
        throw new RuntimeException("\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u8def\u5f84: " + imageDirectory);
    }

    public static String getUuid() {
        return UuidUtils.getUUID();
    }

    public static String generateVerifyCode(@NonNull Integer verifySize) {
        return ValidateCodeUtil.generateVerifyCode(verifySize, false);
    }

    public static String generateNumberVerifyCode(@NonNull Integer verifySize) {
        return ValidateCodeUtil.generateVerifyCode(verifySize, true);
    }

    private static String generateVerifyCode(int verifySize, boolean isNumber) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int length = DIGITS.length;
        StringBuilder verifyCode = new StringBuilder(verifySize);
        for (int i = 0; i < verifySize; ++i) {
            if (isNumber) {
                verifyCode.append((char)DIGITS[((Random)rand).nextInt(10)]);
                continue;
            }
            verifyCode.append((char)DIGITS[Math.abs(((Random)rand).nextInt(length - 2) + 2)]);
        }
        return verifyCode.toString();
    }
}

