/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessorHolder;
import top.dcenter.ums.security.core.api.validate.code.image.ImageCodeFactory;
import top.dcenter.ums.security.core.api.validate.code.slider.SliderCodeFactory;
import top.dcenter.ums.security.core.api.validate.code.sms.SmsCodeSender;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.auth.controller.ValidateCodeController;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeFilter;
import top.dcenter.ums.security.core.auth.validate.codes.image.DefaultImageCodeFactory;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.job.RefreshValidateCodeCacheJobHandler;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SimpleSliderCodeFactory;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCoderProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderValidateCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.sms.DefaultSmsCodeSender;
import top.dcenter.ums.security.core.auth.validate.codes.sms.SmsCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.sms.SmsValidateCodeProcessor;

@Configuration
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class ValidateCodeBeanAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeBeanAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.image.ImageCodeGenerator"})
    public ImageCodeGenerator imageCodeGenerator(ValidateCodeProperties validateCodeProperties, ImageCodeFactory imageCodeFactory) {
        return new ImageCodeGenerator(validateCodeProperties, imageCodeFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.sms.SmsCodeGenerator"})
    public SmsCodeGenerator smsCodeGenerator(ValidateCodeProperties validateCodeProperties, SmsCodeSender smsCodeSender) {
        return new SmsCodeGenerator(validateCodeProperties, smsCodeSender);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.validate.code.sms.SmsCodeSender"})
    public SmsCodeSender smsCodeSender(ValidateCodeProperties validateCodeProperties) {
        return new DefaultSmsCodeSender(validateCodeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.validate.code.image.ImageCodeFactory"})
    public ImageCodeFactory imageCodeFactory(ValidateCodeProperties validateCodeProperties) {
        return new DefaultImageCodeFactory(validateCodeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.image.ImageValidateCodeProcessor"})
    public ImageValidateCodeProcessor imageValidateCodeProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeProperties validateCodeProperties, @Nullable @Autowired(required=false) RedisConnectionFactory redisConnectionFactory) {
        return new ImageValidateCodeProcessor(validateCodeGeneratorHolder, validateCodeProperties.getValidateCodeCacheType(), redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.sms.SmsValidateCodeProcessor"})
    public SmsValidateCodeProcessor smsValidateCodeProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeProperties validateCodeProperties, @Nullable @Autowired(required=false) RedisConnectionFactory redisConnectionFactory) {
        return new SmsValidateCodeProcessor(validateCodeGeneratorHolder, validateCodeProperties.getValidateCodeCacheType(), redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.validate.code.slider.SliderCodeFactory"})
    public SimpleSliderCodeFactory simpleSliderCodeFactory(ValidateCodeProperties validateCodeProperties) {
        return new SimpleSliderCodeFactory(validateCodeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.slider.SliderValidateCodeGenerator"})
    public SliderValidateCodeGenerator sliderValidateCodeGenerator(ValidateCodeProperties validateCodeProperties, SliderCodeFactory sliderCodeFactory) {
        return new SliderValidateCodeGenerator(sliderCodeFactory, validateCodeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCoderProcessor"})
    public SliderCoderProcessor sliderCoderProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeProperties validateCodeProperties, @Nullable @Autowired(required=false) RedisConnectionFactory redisConnectionFactory) {
        return new SliderCoderProcessor(validateCodeGeneratorHolder, validateCodeProperties, redisConnectionFactory);
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.codes", name={"enable-refresh-validate-code-job"}, havingValue="true")
    public RefreshValidateCodeCacheJobHandler refreshValidateCodeJobHandler(ValidateCodeProperties validateCodeProperties, @Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor) {
        return new RefreshValidateCodeCacheJobHandler(validateCodeProperties, jobTaskScheduledExecutor);
    }

    @Bean
    public ValidateCodeProcessorHolder validateCodeProcessorHolder() {
        return new ValidateCodeProcessorHolder();
    }

    @Bean
    public ValidateCodeGeneratorHolder validateCodeGeneratorHolder() {
        return new ValidateCodeGeneratorHolder();
    }

    @Bean
    public ValidateCodeController validateCodeController() {
        return new ValidateCodeController();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeFilter"})
    public ValidateCodeFilter validateCodeFilter(ValidateCodeProcessorHolder validateCodeProcessorHolder, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, ValidateCodeProperties validateCodeProperties) {
        return new ValidateCodeFilter(validateCodeProcessorHolder, baseAuthenticationFailureHandler, validateCodeProperties);
    }
}

