/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.zhyd.oauth.cache.AuthDefaultStateCache;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.request.AuthAlipayRequest;
import me.zhyd.oauth.request.AuthAliyunRequest;
import me.zhyd.oauth.request.AuthBaiduRequest;
import me.zhyd.oauth.request.AuthCodingRequest;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;
import me.zhyd.oauth.request.AuthDouyinRequest;
import me.zhyd.oauth.request.AuthElemeRequest;
import me.zhyd.oauth.request.AuthFacebookRequest;
import me.zhyd.oauth.request.AuthGiteeRequest;
import me.zhyd.oauth.request.AuthGithubRequest;
import me.zhyd.oauth.request.AuthGitlabRequest;
import me.zhyd.oauth.request.AuthGoogleRequest;
import me.zhyd.oauth.request.AuthHuaweiRequest;
import me.zhyd.oauth.request.AuthJdRequest;
import me.zhyd.oauth.request.AuthKujialeRequest;
import me.zhyd.oauth.request.AuthLinkedinRequest;
import me.zhyd.oauth.request.AuthMeituanRequest;
import me.zhyd.oauth.request.AuthMiRequest;
import me.zhyd.oauth.request.AuthMicrosoftRequest;
import me.zhyd.oauth.request.AuthOschinaRequest;
import me.zhyd.oauth.request.AuthPinterestRequest;
import me.zhyd.oauth.request.AuthQqRequest;
import me.zhyd.oauth.request.AuthRenrenRequest;
import me.zhyd.oauth.request.AuthStackOverflowRequest;
import me.zhyd.oauth.request.AuthTaobaoRequest;
import me.zhyd.oauth.request.AuthTeambitionRequest;
import me.zhyd.oauth.request.AuthToutiaoRequest;
import me.zhyd.oauth.request.AuthTwitterRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseRequest;
import me.zhyd.oauth.request.AuthWeChatMpRequest;
import me.zhyd.oauth.request.AuthWeChatOpenRequest;
import me.zhyd.oauth.request.AuthWeiboRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateRedisCache;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateSessionCache;
import top.dcenter.ums.security.core.oauth.justauth.enums.StateCacheType;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.AuthDefaultRequestAdapter;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.BaseAuth2Properties;
import top.dcenter.ums.security.core.oauth.properties.JustAuthProperties;
import top.dcenter.ums.security.core.util.ConvertUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public class Auth2RequestHolder
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(Auth2RequestHolder.class);
    private static final String FIELD_SEPARATOR = "_";
    private static final String CLIENT_ID_FIELD_NAME = "clientId";
    private static final String CLIENT_SECRET_FIELD_NAME = "clientSecret";
    private static final String PROVIDER_ID_FIELD_NAME = "providerId";
    private static final Map<String, Auth2DefaultRequest> PROVIDER_ID_AUTH_REQUEST_MAP = new ConcurrentHashMap<String, Auth2DefaultRequest>();
    private static final Map<AuthDefaultSource, String> SOURCE_PROVIDER_ID_MAP = new ConcurrentHashMap<AuthDefaultSource, String>();
    private ApplicationContext applicationContext;

    @Nullable
    public static Auth2DefaultRequest getAuth2DefaultRequest(String providerId) {
        if (PROVIDER_ID_AUTH_REQUEST_MAP.size() < 1 || providerId == null) {
            return null;
        }
        return PROVIDER_ID_AUTH_REQUEST_MAP.get(providerId);
    }

    public static String getProviderId(AuthDefaultSource source) {
        if (SOURCE_PROVIDER_ID_MAP.size() < 1 || null == source) {
            return null;
        }
        return SOURCE_PROVIDER_ID_MAP.get(source);
    }

    public static Collection<String> getProviderIds() {
        return SOURCE_PROVIDER_ID_MAP.values();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Field[] declaredFields;
        AuthStateCache authStateCache;
        Auth2Properties auth2Properties = (Auth2Properties)this.applicationContext.getBean(Auth2Properties.class);
        JustAuthProperties justAuthProperties = auth2Properties.getJustAuth();
        StateCacheType stateCacheType = justAuthProperties.getCacheType();
        if (stateCacheType.equals((Object)StateCacheType.REDIS)) {
            Class<?> stringRedisTemplateClass = Class.forName("org.springframework.data.redis.core.StringRedisTemplate");
            Object stringRedisTemplate = this.applicationContext.getBean(stringRedisTemplateClass);
            authStateCache = this.getAuthStateCache(stateCacheType, auth2Properties, stringRedisTemplate);
        } else {
            authStateCache = this.getAuthStateCache(stateCacheType, auth2Properties, null);
        }
        Class<Auth2Properties> aClass = Auth2Properties.class;
        for (Field field : declaredFields = aClass.getDeclaredFields()) {
            field.setAccessible(true);
            Auth2Properties oriAuth2Properties = (Auth2Properties)AopProxyUtils.getSingletonTarget((Object)auth2Properties);
            Object baseProperties = field.get(oriAuth2Properties);
            if (!(baseProperties instanceof BaseAuth2Properties)) continue;
            String providerId = field.getName();
            CharSequence[] splits = ConvertUtil.splitByCharacterTypeCamelCase(providerId, true);
            AuthDefaultSource source = AuthDefaultSource.valueOf((String)String.join((CharSequence)FIELD_SEPARATOR, splits).toUpperCase());
            SOURCE_PROVIDER_ID_MAP.put(source, providerId);
            BaseAuth2Properties baseAuth2Properties = (BaseAuth2Properties)baseProperties;
            if (baseAuth2Properties.getClientId() == null || baseAuth2Properties.getClientSecret() == null) continue;
            Auth2DefaultRequest auth2DefaultRequest = this.getAuth2DefaultRequest(source, oriAuth2Properties, authStateCache);
            PROVIDER_ID_AUTH_REQUEST_MAP.put(providerId, auth2DefaultRequest);
        }
    }

    private Auth2DefaultRequest getAuth2DefaultRequest(@NonNull AuthDefaultSource source, @NonNull Auth2Properties auth2Properties, @NonNull AuthStateCache authStateCache) throws IllegalAccessException {
        JustAuthProperties justAuth = auth2Properties.getJustAuth();
        AuthConfig config = this.getAuthConfig(auth2Properties, source);
        config.setScopes(justAuth.getScopes());
        Auth2Properties.HttpConfigProperties proxy = auth2Properties.getProxy();
        config.setHttpConfig(proxy.getHttpConfig());
        config.setIgnoreCheckState(justAuth.getIgnoreCheckState().booleanValue());
        switch (source) {
            case GITHUB: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthGithubRequest.class);
            }
            case WEIBO: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthWeiboRequest.class);
            }
            case GITEE: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthGiteeRequest.class);
            }
            case DINGTALK: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthDingTalkRequest.class);
            }
            case BAIDU: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthBaiduRequest.class);
            }
            case CODING: {
                config.setCodingGroupName(auth2Properties.getCoding().getCodingGroupName());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthCodingRequest.class);
            }
            case OSCHINA: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthOschinaRequest.class);
            }
            case ALIPAY: {
                config.setAlipayPublicKey(auth2Properties.getAlipay().getAlipayPublicKey());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthAlipayRequest.class);
            }
            case QQ: {
                config.setUnionId(auth2Properties.getQq().getUnionId().booleanValue());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthQqRequest.class);
            }
            case WECHAT_OPEN: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthWeChatOpenRequest.class);
            }
            case WECHAT_MP: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthWeChatMpRequest.class);
            }
            case TAOBAO: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthTaobaoRequest.class);
            }
            case GOOGLE: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthGoogleRequest.class);
            }
            case FACEBOOK: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthFacebookRequest.class);
            }
            case DOUYIN: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthDouyinRequest.class);
            }
            case LINKEDIN: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthLinkedinRequest.class);
            }
            case MICROSOFT: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthMicrosoftRequest.class);
            }
            case MI: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthMiRequest.class);
            }
            case TOUTIAO: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthToutiaoRequest.class);
            }
            case TEAMBITION: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthTeambitionRequest.class);
            }
            case RENREN: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthRenrenRequest.class);
            }
            case PINTEREST: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthPinterestRequest.class);
            }
            case STACK_OVERFLOW: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                config.setStackOverflowKey(auth2Properties.getStackOverflow().getStackOverflowKey());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthStackOverflowRequest.class);
            }
            case HUAWEI: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthHuaweiRequest.class);
            }
            case WECHAT_ENTERPRISE: {
                config.setAgentId(auth2Properties.getWechatEnterprise().getAgentId());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthWeChatEnterpriseRequest.class);
            }
            case KUJIALE: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthKujialeRequest.class);
            }
            case GITLAB: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthGitlabRequest.class);
            }
            case MEITUAN: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthMeituanRequest.class);
            }
            case ELEME: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthElemeRequest.class);
            }
            case TWITTER: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthTwitterRequest.class);
            }
            case JD: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthJdRequest.class);
            }
            case ALIYUN: {
                return this.getAuthDefaultRequestAdapter(config, source, authStateCache, AuthAliyunRequest.class);
            }
        }
        return null;
    }

    private AuthDefaultRequestAdapter getAuthDefaultRequestAdapter(@NonNull AuthConfig config, @NonNull AuthDefaultSource source, @NonNull AuthStateCache authStateCache, @NonNull Class<? extends AuthDefaultRequest> clz) {
        AuthDefaultRequestAdapter adapter = new AuthDefaultRequestAdapter(config, source, authStateCache);
        Class[] argumentTypes = new Class[]{AuthConfig.class, AuthStateCache.class};
        Object[] arguments = new Object[]{config, authStateCache};
        AuthDefaultRequest proxyObject = this.createProxy(clz, argumentTypes, arguments, adapter);
        adapter.setAuthDefaultRequest(proxyObject);
        return adapter;
    }

    private AuthDefaultRequest createProxy(Class<? extends AuthDefaultRequest> targetClass, Class<?>[] argumentTypes, Object[] arguments, AuthDefaultRequestAdapter adapter) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setCallback((Callback)((MethodInterceptor)(target, method, args, methodProxy) -> {
            if (target instanceof AuthDefaultRequest && !(target instanceof AuthDefaultRequestAdapter) && "getRealState".equals(method.getName())) {
                return adapter.getRealState((String)args[0]);
            }
            return methodProxy.invokeSuper(target, args);
        }));
        return (AuthDefaultRequest)enhancer.create((Class[])argumentTypes, arguments);
    }

    private AuthStateCache getAuthStateCache(StateCacheType type, Auth2Properties auth2Properties, Object stringRedisTemplate) {
        switch (type) {
            case DEFAULT: {
                return AuthDefaultStateCache.INSTANCE;
            }
            case SESSION: {
                return new AuthStateSessionCache(auth2Properties);
            }
            case REDIS: {
                if (stringRedisTemplate == null) {
                    throw new RuntimeException(String.format("applicationContext \u4e2d\u83b7\u53d6\u4e0d\u5230 %s, %s \u7c7b\u578b\u7684\u7f13\u5b58\u65e0\u6cd5\u521b\u5efa!", "org.springframework.data.redis.core.StringRedisTemplate", type.name()));
                }
                return new AuthStateRedisCache(auth2Properties, stringRedisTemplate);
            }
        }
        log.error("{} \u7c7b\u578b\u4e0d\u5339\u914d, \u4f7f\u7528 {} \u7c7b\u578b\u7f13\u5b58\u66ff\u4ee3", (Object)StateCacheType.class.getName(), (Object)StateCacheType.DEFAULT.name());
        return AuthDefaultStateCache.INSTANCE;
    }

    private AuthConfig getAuthConfig(@NonNull Auth2Properties auth2Properties, @NonNull AuthDefaultSource source) throws IllegalAccessException, NullPointerException {
        AuthConfig.AuthConfigBuilder builder = AuthConfig.builder();
        String fieldName = Auth2RequestHolder.getProviderId(source);
        Class<?> aClass = auth2Properties.getClass();
        Field[] declaredFields = aClass.getDeclaredFields();
        Object providerProperties = null;
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            providerProperties = field.get(auth2Properties);
            break;
        }
        String providerId = "";
        Objects.requireNonNull(providerProperties, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 BaseAuth2Properties \u7684\u5b50\u7c7b", source.name()));
        for (Field field : declaredFields = providerProperties.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!PROVIDER_ID_FIELD_NAME.equals(field.getName())) continue;
            providerId = (String)field.get(providerProperties);
            Objects.requireNonNull(providerId, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), PROVIDER_ID_FIELD_NAME));
        }
        Class<BaseAuth2Properties> baseClass = BaseAuth2Properties.class;
        for (Field field : declaredFields = baseClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (CLIENT_ID_FIELD_NAME.equals(field.getName())) {
                String clientId = (String)field.get(providerProperties);
                Objects.requireNonNull(clientId, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), CLIENT_ID_FIELD_NAME));
                builder.clientId(clientId);
            }
            if (!CLIENT_SECRET_FIELD_NAME.equals(field.getName())) continue;
            String clientSecret = (String)field.get(providerProperties);
            Objects.requireNonNull(clientSecret, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), CLIENT_SECRET_FIELD_NAME));
            builder.clientSecret(clientSecret);
        }
        String redirectUri = auth2Properties.getDomain() + MvcUtil.getServletContextPath() + auth2Properties.getRedirectUrlPrefix() + "/" + providerId;
        return builder.redirectUri(redirectUri).build();
    }

    public static String getProviderIdBySource(@NonNull AuthDefaultSource source) {
        String name = source.name().toLowerCase();
        String[] splits = name.split(FIELD_SEPARATOR);
        String fieldName = name;
        if (splits.length > 1) {
            String secondName = splits[1];
            fieldName = splits[0] + secondName.substring(0, 1).toUpperCase() + secondName.substring(1);
        }
        return fieldName;
    }
}

