/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth.request;

import com.xkcoding.http.exception.SimpleHttpException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.log.Log;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthChecker;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UuidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.dcenter.ums.security.core.exception.RefreshTokenFailureException;
import top.dcenter.ums.security.core.oauth.entity.AuthTokenPo;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;

public class AuthDefaultRequestAdapter
extends AuthDefaultRequest
implements Auth2DefaultRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthDefaultRequestAdapter.class);
    private final String providerId;
    private AuthDefaultRequest authDefaultRequest;

    public AuthDefaultRequestAdapter(AuthConfig config, AuthDefaultSource source, AuthStateCache authStateCache) {
        super(config, (AuthSource)source, authStateCache);
        this.providerId = Auth2RequestHolder.getProviderId(source);
    }

    public void setAuthDefaultRequest(AuthDefaultRequest authDefaultRequest) {
        this.authDefaultRequest = authDefaultRequest;
    }

    public String getRealState(String state) {
        if (StringUtils.isEmpty((String)state)) {
            state = UuidUtils.getUUID();
        }
        this.authStateCache.cache(Auth2DefaultRequest.determineState(this.authStateCache, state, (AuthDefaultSource)this.source), state);
        return state;
    }

    @Override
    public AuthResponse login(AuthCallback authCallback) {
        try {
            AuthChecker.checkCode((AuthSource)this.source, (AuthCallback)authCallback);
            if (!this.config.isIgnoreCheckState()) {
                AuthChecker.checkState((String)Auth2DefaultRequest.determineState(this.authStateCache, authCallback.getState(), (AuthDefaultSource)this.source), (AuthSource)this.source, (AuthStateCache)this.authStateCache);
            }
            AuthToken authToken = this.getAccessToken(authCallback);
            AuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data((Object)user).build();
        }
        catch (Exception e) {
            Log.error((String)"Failed to login with oauth authorization.", (Throwable)e);
            return Auth2DefaultRequest.responseError(e);
        }
    }

    @Override
    public AuthTokenPo refreshToken(AuthTokenPo authToken) throws SimpleHttpException, AuthException, RefreshTokenFailureException {
        if (this.authDefaultRequest == null) {
            throw new RuntimeException("AuthDefaultRequest \u4e0d\u80fd\u4e3a null \u503c, \u5fc5\u987b\u901a\u8fc7\u65b9\u6cd5 setAuthDefaultRequest(AuthDefaultRequest) \u8bbe\u7f6e");
        }
        AuthResponse authResponse = this.authDefaultRequest.refresh((AuthToken)authToken);
        return Auth2DefaultRequest.getAuthTokenPo(this.config.getHttpConfig().getTimeout(), authToken.getId(), authResponse);
    }

    @Override
    public AuthDefaultSource getAuthSource() {
        return (AuthDefaultSource)this.source;
    }

    @Override
    public AuthStateCache getAuthStateCache() {
        return this.authStateCache;
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) throws SimpleHttpException {
        try {
            Method method = this.getMethod("getAccessToken", AuthCallback.class);
            Object result = method.invoke((Object)this.authDefaultRequest, authCallback);
            return (AuthToken)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String errMsg = e.getMessage();
            if (e instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)e;
                errMsg = invocationTargetException.getTargetException().getMessage();
            }
            String msg = "\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6 accessToken \u65f6\u65b9\u6cd5\u8c03\u7528\u5f02\u5e38: " + errMsg;
            log.error(msg);
            throw new SimpleHttpException(msg, (Throwable)e);
        }
    }

    @Override
    @Nullable
    public AuthUser getUserInfo(AuthToken authToken) throws SimpleHttpException {
        try {
            Method method = this.getMethod("getUserInfo", AuthToken.class);
            Object result = method.invoke((Object)this.authDefaultRequest, authToken);
            return (AuthUser)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String errMsg = e.getMessage();
            if (e instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)e;
                errMsg = invocationTargetException.getTargetException().getMessage();
            }
            String msg = "\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65f6\u65b9\u6cd5\u8c03\u7528\u5f02\u5e38: " + errMsg;
            log.error(msg);
            throw new SimpleHttpException(msg, (Throwable)e);
        }
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String authorize(String state) {
        if (this.authDefaultRequest == null) {
            throw new RuntimeException("AuthDefaultRequest \u4e0d\u80fd\u4e3a null \u503c, \u5fc5\u987b\u901a\u8fc7\u65b9\u6cd5 setAuthDefaultRequest(AuthDefaultRequest) \u8bbe\u7f6e");
        }
        return this.authDefaultRequest.authorize(state);
    }

    private Method getMethod(@NonNull String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = this.authDefaultRequest.getClass().getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method;
    }
}

