/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
public class UriAuthorizeAutoConfigurerAware
implements HttpSecurityAware,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UriAuthorizeAutoConfigurerAware.class);
    private final ClientProperties clientProperties;
    private ApplicationContext applicationContext;

    public UriAuthorizeAutoConfigurerAware(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) {
    }

    public void preConfigure(HttpSecurity http) {
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Set<String>> accessMap = new HashMap<UriHttpMethodTuple, Set<String>>(16);
        String accessExp = this.clientProperties.getAccessExp();
        if (this.clientProperties.getEnableRestfulApi().booleanValue()) {
            accessExp = this.clientProperties.getRestfulAccessExp();
        }
        try {
            this.applicationContext.getBean(GlobalMethodSecurityConfiguration.class);
            accessExp = this.clientProperties.getAccessExp();
        }
        catch (Exception exception) {
            // empty catch block
        }
        accessMap.put(UriHttpMethodTuple.tuple(null, (String)accessExp), Collections.singleton(accessExp));
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("access", accessMap);
        return resultMap;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

