/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.exception.IllegalAccessUrlException;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.IpUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

@Api(tags={"session \u5931\u6548\u540e\u8df3\u8f6c\u5904\u7406"})
@ResponseBody
public class InvalidSessionController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(InvalidSessionController.class);
    private final RedirectStrategy redirectStrategy;
    private final ClientProperties clientProperties;
    private final RequestCache requestCache;
    @Autowired
    private GenericApplicationContext applicationContext;

    public InvalidSessionController(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.requestCache = new HttpSessionRequestCache();
        this.redirectStrategy = new DefaultRedirectStrategy();
    }

    @ApiOperation(value="session \u5931\u6548\u540e\u8df3\u8f6c\u5904\u7406", notes="\u83b7\u53d6\u539f\u59cb\u8bf7\u6c42 uri, \u6839\u636e LoginProcessType \u8fdb\u884c\u8df3\u8f6c\u767b\u5f55\u63a5\u53e3\u6216\u8fd4\u56de\u76f8\u5e94 json \u6570\u636e", httpMethod="GET")
    @RequestMapping(value={"/session/invalid"}, method={RequestMethod.GET})
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public void invalidSessionHandler(HttpServletRequest request, HttpServletResponse response) {
        try {
            String redirectUrl = AuthenticationUtil.getOriginalUrl(this.requestCache, request, response, this.clientProperties.getLoginPage());
            AuthenticationUtil.redirectProcessingByLoginProcessType(request, response, this.clientProperties, this.redirectStrategy, ErrorCodeEnum.INVALID_SESSION, redirectUrl);
        }
        catch (Exception e) {
            String requestUri = request.getRequestURI();
            String ip = IpUtil.getRealIp(request);
            String msg = String.format("IllegalAccessUrlException: ip=%s, uri=%s, sid=%s, error=%s", ip, requestUri, request.getSession(true).getId(), e.getMessage());
            log.error(msg, (Throwable)e);
            throw new IllegalAccessUrlException(ErrorCodeEnum.SERVER_ERROR, requestUri, ip);
        }
    }

    public void afterPropertiesSet() throws Exception {
        String methodName = "invalidSessionHandler";
        MvcUtil.setRequestMappingUri(methodName, this.clientProperties.getSession().getInvalidSessionUrl(), this.getClass(), HttpServletRequest.class, HttpServletResponse.class);
        MvcUtil.registerController("invalidSessionController", this.applicationContext, InvalidSessionController.class);
    }
}

