/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.utils.UuidUtils;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;
import top.dcenter.ums.security.core.util.MvcUtil;

public class MdcLogFilter
extends OncePerRequestFilter {
    public static final String MDC_KEY = "MDC_TRACE_ID";
    private final Set<String> includeUrls;
    private final Set<String> excludeUrls;
    private final AntPathMatcher matcher = new AntPathMatcher();

    public MdcLogFilter(MdcProperties mdcProperties, ClientProperties clientProperties) {
        Set<String> excludeUrls;
        this.includeUrls = new HashSet<String>();
        this.excludeUrls = new HashSet<String>();
        this.includeUrls.addAll(mdcProperties.getIncludeUrls());
        String[] ignoringUrls = clientProperties.getIgnoringUrls();
        if (null != ignoringUrls) {
            this.excludeUrls.addAll(Arrays.asList(ignoringUrls));
        }
        if (null != (excludeUrls = mdcProperties.getExcludeUrls())) {
            this.excludeUrls.addAll(excludeUrls);
        }
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (this.isMdc(request)) {
            String token = UuidUtils.getUUID();
            MDC.put((String)MDC_KEY, (String)token);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            MDC.remove((String)MDC_KEY);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isMdc(HttpServletRequest request) {
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        for (String excludeUrl : this.excludeUrls) {
            if (!this.matcher.match(excludeUrl, requestUri)) continue;
            return false;
        }
        for (String includeUrl : this.includeUrls) {
            if (!this.matcher.match(includeUrl, requestUri)) continue;
            return true;
        }
        return false;
    }
}

