/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.api.oauth.state.service.Auth2StateCoder;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.oauth.config.Auth2PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.oauth.job.RefreshAccessTokenJobHandler;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJob;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJobImpl;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.RepositoryProperties;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;
import top.dcenter.ums.security.core.oauth.repository.factory.Auth2JdbcUsersConnectionRepositoryFactory;
import top.dcenter.ums.security.core.oauth.repository.factory.UsersConnectionRepositoryFactory;
import top.dcenter.ums.security.core.oauth.repository.jdbc.Auth2JdbcUsersConnectionTokenRepository;
import top.dcenter.ums.security.core.oauth.service.Auth2UserService;
import top.dcenter.ums.security.core.oauth.service.DefaultAuth2UserServiceImpl;
import top.dcenter.ums.security.core.oauth.signup.ConnectionService;
import top.dcenter.ums.security.core.oauth.signup.DefaultConnectionServiceImpl;

@Configuration
@AutoConfigureAfter(value={Auth2PropertiesAutoConfiguration.class})
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
public class Auth2AutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Auth2AutoConfiguration.class);
    private final RepositoryProperties repositoryProperties;
    private final Auth2Properties auth2Properties;
    private final DataSource dataSource;

    public Auth2AutoConfiguration(RepositoryProperties repositoryProperties, Auth2Properties auth2Properties, DataSource dataSource) {
        this.repositoryProperties = repositoryProperties;
        this.auth2Properties = auth2Properties;
        this.dataSource = dataSource;
    }

    @Bean
    public RefreshTokenJob refreshTokenJob(UsersConnectionTokenRepository usersConnectionTokenRepository, UsersConnectionRepository usersConnectionRepository, @Qualifier(value="refreshTokenTaskExecutor") ExecutorService refreshTokenTaskExecutor) {
        return new RefreshTokenJobImpl(usersConnectionRepository, usersConnectionTokenRepository, this.auth2Properties, refreshTokenTaskExecutor);
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-refresh-token-job"}, havingValue="true")
    public RefreshAccessTokenJobHandler refreshAccessTokenJobHandler(@Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor, Auth2Properties auth2Properties) {
        return new RefreshAccessTokenJobHandler(auth2Properties, jobTaskScheduledExecutor);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.service.Auth2UserService"})
    public Auth2UserService auth2UserService() {
        return new DefaultAuth2UserServiceImpl();
    }

    @Bean
    public JdbcTemplate auth2UserConnectionJdbcTemplate() {
        return new JdbcTemplate(this.dataSource);
    }

    @Bean
    public UsersConnectionRepository usersConnectionRepository(UsersConnectionRepositoryFactory usersConnectionRepositoryFactory, JdbcTemplate auth2UserConnectionJdbcTemplate, @Qualifier(value="connectionTextEncryptor") TextEncryptor connectionTextEncryptor) {
        return usersConnectionRepositoryFactory.getUsersConnectionRepository(auth2UserConnectionJdbcTemplate, connectionTextEncryptor, this.repositoryProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository"})
    public UsersConnectionTokenRepository usersConnectionTokenRepository(TextEncryptor connectionTextEncryptor, JdbcTemplate auth2UserConnectionJdbcTemplate) {
        return new Auth2JdbcUsersConnectionTokenRepository(auth2UserConnectionJdbcTemplate, connectionTextEncryptor);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.repository.factory.UsersConnectionRepositoryFactory"})
    public UsersConnectionRepositoryFactory usersConnectionRepositoryFactory() {
        return new Auth2JdbcUsersConnectionRepositoryFactory();
    }

    @Bean
    public TextEncryptor connectionTextEncryptor(RepositoryProperties repositoryProperties) {
        return Encryptors.text((CharSequence)repositoryProperties.getTextEncryptorPassword(), (CharSequence)repositoryProperties.getTextEncryptorSalt());
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.signup.ConnectionService"})
    public ConnectionService connectionSignUp(UmsUserDetailsService userDetailsService, UsersConnectionTokenRepository usersConnectionTokenRepository, UsersConnectionRepository usersConnectionRepository, @Autowired(required=false) Auth2StateCoder auth2StateCoder) {
        return new DefaultConnectionServiceImpl(userDetailsService, this.auth2Properties, usersConnectionRepository, usersConnectionTokenRepository, auth2StateCoder);
    }

    @Bean
    public Auth2RequestHolder auth2RequestHolder() {
        return new Auth2RequestHolder();
    }

    public void afterPropertiesSet() throws Exception {
        block103: {
            try (Connection connection = this.dataSource.getConnection();){
                String database;
                Object resultSet;
                if (connection == null) {
                    log.error("\u9519\u8bef: \u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 {} \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Object)this.repositoryProperties.getTableName());
                    throw new Exception(String.format("\u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 %s \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", this.repositoryProperties.getTableName()));
                }
                try (PreparedStatement preparedStatement = connection.prepareStatement("select database();");){
                    resultSet = preparedStatement.executeQuery();
                    Throwable throwable = null;
                    try {
                        resultSet.next();
                        database = resultSet.getString(1);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
                if (StringUtils.hasText((String)database)) {
                    Throwable throwable;
                    block102: {
                        String queryUserConnectionTableExistSql = this.repositoryProperties.getQueryUserConnectionTableExistSql(database);
                        PreparedStatement preparedStatement1 = connection.prepareStatement(queryUserConnectionTableExistSql);
                        resultSet = null;
                        try {
                            throwable = null;
                            try (ResultSet resultSet2 = preparedStatement1.executeQuery();){
                                resultSet2.next();
                                int tableCount = resultSet2.getInt(1);
                                if (tableCount >= 1) break block102;
                                String creatUserConnectionTableSql = this.repositoryProperties.getCreatUserConnectionTableSql();
                                try (PreparedStatement preparedStatement = connection.prepareStatement(creatUserConnectionTableSql);){
                                    preparedStatement.executeUpdate();
                                    log.info("{} \u8868\u521b\u5efa\u6210\u529f\uff0cSQL\uff1a{}", (Object)this.repositoryProperties.getTableName(), (Object)creatUserConnectionTableSql);
                                    if (!connection.getAutoCommit()) {
                                        connection.commit();
                                    }
                                }
                            }
                            catch (Throwable tableCount) {
                                throwable = tableCount;
                                throw tableCount;
                            }
                        }
                        catch (Throwable resultSet2) {
                            resultSet = resultSet2;
                            throw resultSet2;
                        }
                        finally {
                            if (preparedStatement1 != null) {
                                if (resultSet != null) {
                                    try {
                                        preparedStatement1.close();
                                    }
                                    catch (Throwable resultSet2) {
                                        ((Throwable)resultSet).addSuppressed(resultSet2);
                                    }
                                } else {
                                    preparedStatement1.close();
                                }
                            }
                        }
                    }
                    String authTokenTable = "auth_token";
                    String queryAuthTokenTableExistSql = "SELECT COUNT(1) FROM information_schema.tables WHERE table_schema='" + database + "' AND table_name = '" + authTokenTable + "'";
                    throwable = null;
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement(queryAuthTokenTableExistSql);
                         ResultSet resultSet3 = preparedStatement2.executeQuery();){
                        resultSet3.next();
                        int tableCount = resultSet3.getInt(1);
                        if (tableCount < 1) {
                            String creatAuthTokenTableSql = "CREATE TABLE `" + authTokenTable + "` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `accessToken` varchar(255) COMMENT 'accessToken',\n  `expireIn` bigint(20) COMMENT '\u8fc7\u671f\u65f6\u95f4',\n  `refreshToken` varchar(255) COMMENT 'refreshToken',\n  `uid` varchar(11) COMMENT 'alipay userId',\n  `openId` varchar(255) COMMENT 'qq/mi/toutiao/wechatMp/wechatOpen/weibo/jd/kujiale/dingTalk/douyin/feishu',\n  `accessCode` varchar(512) COMMENT 'dingTalk, taobao \u9644\u5e26\u5c5e\u6027',\n  `unionId` varchar(512) COMMENT 'QQ\u9644\u5e26\u5c5e\u6027',\n  `scope` varchar(512) COMMENT 'Google\u9644\u5e26\u5c5e\u6027',\n  `tokenType` varchar(512) COMMENT 'Google\u9644\u5e26\u5c5e\u6027',\n  `idToken` varchar(512) COMMENT 'Google\u9644\u5e26\u5c5e\u6027',\n  `macAlgorithm` varchar(512) COMMENT '\u5c0f\u7c73\u9644\u5e26\u5c5e\u6027',\n  `macKey` varchar(512) COMMENT '\u5c0f\u7c73\u9644\u5e26\u5c5e\u6027',\n  `code` varchar(512) COMMENT '\u4f01\u4e1a\u5fae\u4fe1\u9644\u5e26\u5c5e\u6027',\n  `oauthToken` varchar(512) COMMENT 'Twitter\u9644\u5e26\u5c5e\u6027',\n  `oauthTokenSecret` varchar(512) COMMENT 'Twitter\u9644\u5e26\u5c5e\u6027',\n  `userId` varchar(512) COMMENT 'Twitter\u9644\u5e26\u5c5e\u6027',\n  `screenName` varchar(512) COMMENT 'Twitter\u9644\u5e26\u5c5e\u6027',\n  `oauthCallbackConfirmed` varchar(512) COMMENT 'Twitter\u9644\u5e26\u5c5e\u6027',\n  PRIMARY KEY (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
                            connection.prepareStatement(creatAuthTokenTableSql).executeUpdate();
                            log.info("{} \u8868\u521b\u5efa\u6210\u529f\uff0cSQL\uff1a{}", (Object)authTokenTable, (Object)creatAuthTokenTableSql);
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                            }
                        }
                        break block103;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                log.error("\u9519\u8bef: \u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 {} \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Object)this.repositoryProperties.getTableName());
                throw new Exception(String.format("\u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 %s \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", this.repositoryProperties.getTableName()));
            }
        }
    }
}

