/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.support.GenericWebApplicationContext;
import top.dcenter.ums.security.core.api.advice.SecurityControllerAdviceHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.logout.DefaultLogoutSuccessHandler;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.controller.ClientSecurityController;
import top.dcenter.ums.security.core.auth.handler.ClientAuthenticationFailureHandler;
import top.dcenter.ums.security.core.auth.handler.ClientAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.util.MvcUtil;

@Configuration(proxyBeanMethods=false)
@Order(value=99)
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
public class SecurityAutoConfiguration
implements InitializingBean {
    private final ClientProperties clientProperties;
    @Autowired
    private UmsUserDetailsService umsUserDetailsService;
    @Autowired
    private GenericApplicationContext applicationContext;

    public SecurityAutoConfiguration(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler"})
    public BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler(Auth2Properties auth2Properties) {
        return new ClientAuthenticationSuccessHandler(this.clientProperties, MvcUtil.getServletContextPath() + auth2Properties.getRedirectUrlPrefix());
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler"})
    public BaseAuthenticationFailureHandler baseAuthenticationFailureHandler() {
        return new ClientAuthenticationFailureHandler(this.clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.advice.SecurityControllerAdviceHandler"})
    public SecurityControllerAdviceHandler securityControllerExceptionHandler() {
        return new SecurityControllerAdviceHandler();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider"})
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(PasswordEncoder passwordEncoder) {
        return new UsernamePasswordAuthenticationProvider(passwordEncoder, this.umsUserDetailsService);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.logout.DefaultLogoutSuccessHandler"})
    public DefaultLogoutSuccessHandler defaultLogoutSuccessHandler() {
        return new DefaultLogoutSuccessHandler(this.clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.controller.BaseSecurityController"})
    @ConditionalOnProperty(prefix="ums.client", name={"open-authentication-redirect"}, havingValue="true")
    public ClientSecurityController clientSecurityController() {
        return new ClientSecurityController(this.clientProperties);
    }

    public void afterPropertiesSet() throws Exception {
        Field[] declaredFields;
        if (this.clientProperties.getSuppressReflectWarning().booleanValue()) {
            SecurityAutoConfiguration.disableAccessWarnings();
        }
        Class<MvcUtil> mvcUtilClass = MvcUtil.class;
        Class.forName(mvcUtilClass.getName());
        for (Field field : declaredFields = mvcUtilClass.getDeclaredFields()) {
            String contextPath;
            field.setAccessible(true);
            if (!Objects.equals(field.getName(), "servletContextPath")) continue;
            try {
                contextPath = Objects.requireNonNull(((AnnotationConfigServletWebServerApplicationContext)this.applicationContext).getServletContext()).getContextPath();
            }
            catch (Exception e) {
                contextPath = Objects.requireNonNull(((GenericWebApplicationContext)this.applicationContext).getServletContext()).getContextPath();
            }
            field.set(null, contextPath);
        }
    }

    private static void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

