/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.properties;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.config.http.SessionCreationPolicy;
import top.dcenter.ums.security.common.enums.CsrfTokenRepositoryType;
import top.dcenter.ums.security.common.enums.LoginProcessType;

@ConfigurationProperties(value="ums.client")
public class ClientProperties {
    private final SessionProperties session = new SessionProperties();
    private final RememberMeProperties rememberMe = new RememberMeProperties();
    private final CsrfProperties csrf = new CsrfProperties();
    private final AnonymousProperties anonymous = new AnonymousProperties();
    private List<String> roleHierarchy = new ArrayList<String>();
    private String loginPage = "/login";
    private String loginProcessingUrl = "/authentication/form";
    private String failureUrl = this.loginPage;
    private String successUrl = "/";
    private String accessDenyPage;
    private String[] ignoringUrls;
    private Set<String> permitUrls = new HashSet<String>();
    private String accessExp = "isAuthenticated()";
    private String restfulAccessExp = "hasPermission(request, authentication)";
    private Boolean enableRestfulApi = true;
    private Boolean openAuthenticationRedirect = false;
    private String loginUnAuthenticationRoutingUrl = "/authentication/require";
    private List<String> authRedirectSuffixCondition = new ArrayList<String>();
    private LoginProcessType loginProcessType = LoginProcessType.JSON;
    public String logoutUrl = "/logout";
    public String logoutSuccessUrl = "/login";
    public String targetUrlParameter = "redirectTargetUrl";
    public String usernameParameter = "username";
    public String passwordParameter = "password";
    public Boolean useReferer = true;
    public Boolean sameOrigin = Boolean.FALSE;
    private Boolean suppressReflectWarning = false;

    public String getQueryRememberMeTableExistSql(String databaseName) {
        return "SELECT COUNT(1) FROM information_schema.tables WHERE table_schema='" + databaseName + "' AND table_name = 'persistent_logins'";
    }

    public SessionProperties getSession() {
        return this.session;
    }

    public RememberMeProperties getRememberMe() {
        return this.rememberMe;
    }

    public CsrfProperties getCsrf() {
        return this.csrf;
    }

    public AnonymousProperties getAnonymous() {
        return this.anonymous;
    }

    public List<String> getRoleHierarchy() {
        return this.roleHierarchy;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public String getLoginProcessingUrl() {
        return this.loginProcessingUrl;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public String getAccessDenyPage() {
        return this.accessDenyPage;
    }

    public String[] getIgnoringUrls() {
        return this.ignoringUrls;
    }

    public Set<String> getPermitUrls() {
        return this.permitUrls;
    }

    public String getAccessExp() {
        return this.accessExp;
    }

    public String getRestfulAccessExp() {
        return this.restfulAccessExp;
    }

    public Boolean getEnableRestfulApi() {
        return this.enableRestfulApi;
    }

    public Boolean getOpenAuthenticationRedirect() {
        return this.openAuthenticationRedirect;
    }

    public String getLoginUnAuthenticationRoutingUrl() {
        return this.loginUnAuthenticationRoutingUrl;
    }

    public List<String> getAuthRedirectSuffixCondition() {
        return this.authRedirectSuffixCondition;
    }

    public LoginProcessType getLoginProcessType() {
        return this.loginProcessType;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public String getTargetUrlParameter() {
        return this.targetUrlParameter;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public Boolean getUseReferer() {
        return this.useReferer;
    }

    public Boolean getSameOrigin() {
        return this.sameOrigin;
    }

    public Boolean getSuppressReflectWarning() {
        return this.suppressReflectWarning;
    }

    public void setRoleHierarchy(List<String> roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public void setLoginProcessingUrl(String loginProcessingUrl) {
        this.loginProcessingUrl = loginProcessingUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public void setAccessDenyPage(String accessDenyPage) {
        this.accessDenyPage = accessDenyPage;
    }

    public void setIgnoringUrls(String[] ignoringUrls) {
        this.ignoringUrls = ignoringUrls;
    }

    public void setPermitUrls(Set<String> permitUrls) {
        this.permitUrls = permitUrls;
    }

    public void setAccessExp(String accessExp) {
        this.accessExp = accessExp;
    }

    public void setRestfulAccessExp(String restfulAccessExp) {
        this.restfulAccessExp = restfulAccessExp;
    }

    public void setEnableRestfulApi(Boolean enableRestfulApi) {
        this.enableRestfulApi = enableRestfulApi;
    }

    public void setOpenAuthenticationRedirect(Boolean openAuthenticationRedirect) {
        this.openAuthenticationRedirect = openAuthenticationRedirect;
    }

    public void setLoginUnAuthenticationRoutingUrl(String loginUnAuthenticationRoutingUrl) {
        this.loginUnAuthenticationRoutingUrl = loginUnAuthenticationRoutingUrl;
    }

    public void setAuthRedirectSuffixCondition(List<String> authRedirectSuffixCondition) {
        this.authRedirectSuffixCondition = authRedirectSuffixCondition;
    }

    public void setLoginProcessType(LoginProcessType loginProcessType) {
        this.loginProcessType = loginProcessType;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        this.targetUrlParameter = targetUrlParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setUseReferer(Boolean useReferer) {
        this.useReferer = useReferer;
    }

    public void setSameOrigin(Boolean sameOrigin) {
        this.sameOrigin = sameOrigin;
    }

    public void setSuppressReflectWarning(Boolean suppressReflectWarning) {
        this.suppressReflectWarning = suppressReflectWarning;
    }

    public static class AnonymousProperties {
        private Boolean anonymousIsOpen = true;
        private String principal = "ANONYMOUS";
        private List<String> authorities = new ArrayList<String>(Collections.singletonList("ROLE_ANONYMOUS"));

        public Boolean getAnonymousIsOpen() {
            return this.anonymousIsOpen;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public List<String> getAuthorities() {
            return this.authorities;
        }

        public void setAnonymousIsOpen(Boolean anonymousIsOpen) {
            this.anonymousIsOpen = anonymousIsOpen;
        }

        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        public void setAuthorities(List<String> authorities) {
            this.authorities = authorities;
        }
    }

    public static class CsrfProperties {
        private Boolean csrfIsOpen = false;
        private Set<String> ignoringAntMatcherUrls = new HashSet<String>();
        private CsrfTokenRepositoryType tokenRepositoryType = CsrfTokenRepositoryType.SESSION;

        public Boolean getCsrfIsOpen() {
            return this.csrfIsOpen;
        }

        public Set<String> getIgnoringAntMatcherUrls() {
            return this.ignoringAntMatcherUrls;
        }

        public CsrfTokenRepositoryType getTokenRepositoryType() {
            return this.tokenRepositoryType;
        }

        public void setCsrfIsOpen(Boolean csrfIsOpen) {
            this.csrfIsOpen = csrfIsOpen;
        }

        public void setIgnoringAntMatcherUrls(Set<String> ignoringAntMatcherUrls) {
            this.ignoringAntMatcherUrls = ignoringAntMatcherUrls;
        }

        public void setTokenRepositoryType(CsrfTokenRepositoryType tokenRepositoryType) {
            this.tokenRepositoryType = tokenRepositoryType;
        }
    }

    public static class RememberMeProperties {
        private Boolean enable = false;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration rememberMeTimeout = Duration.parse("P14D");
        private String rememberMeCookieName = "REMEMBER_ME";
        private String rememberMeParameter = "REMEMBER_ME";
        private Boolean useSecureCookie = false;

        public Boolean getEnable() {
            return this.enable;
        }

        public Duration getRememberMeTimeout() {
            return this.rememberMeTimeout;
        }

        public String getRememberMeCookieName() {
            return this.rememberMeCookieName;
        }

        public String getRememberMeParameter() {
            return this.rememberMeParameter;
        }

        public Boolean getUseSecureCookie() {
            return this.useSecureCookie;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public void setRememberMeTimeout(Duration rememberMeTimeout) {
            this.rememberMeTimeout = rememberMeTimeout;
        }

        public void setRememberMeCookieName(String rememberMeCookieName) {
            this.rememberMeCookieName = rememberMeCookieName;
        }

        public void setRememberMeParameter(String rememberMeParameter) {
            this.rememberMeParameter = rememberMeParameter;
        }

        public void setUseSecureCookie(Boolean useSecureCookie) {
            this.useSecureCookie = useSecureCookie;
        }
    }

    public static class SessionProperties {
        private Boolean sessionNumberControl = false;
        private Integer maximumSessions = 1;
        private Boolean maxSessionsPreventsLogin = false;
        private Boolean enableSessionUrlRewriting = false;
        private SessionCreationPolicy sessionCreationPolicy = SessionCreationPolicy.ALWAYS;
        private String invalidSessionUrl = "/session/invalid";
        private String invalidSessionOfConcurrentUrl = "/";
        private String sessionCookieName = "JSESSIONID";

        public Boolean getSessionNumberControl() {
            return this.sessionNumberControl;
        }

        public Integer getMaximumSessions() {
            return this.maximumSessions;
        }

        public Boolean getMaxSessionsPreventsLogin() {
            return this.maxSessionsPreventsLogin;
        }

        public Boolean getEnableSessionUrlRewriting() {
            return this.enableSessionUrlRewriting;
        }

        public SessionCreationPolicy getSessionCreationPolicy() {
            return this.sessionCreationPolicy;
        }

        public String getInvalidSessionUrl() {
            return this.invalidSessionUrl;
        }

        public String getInvalidSessionOfConcurrentUrl() {
            return this.invalidSessionOfConcurrentUrl;
        }

        public String getSessionCookieName() {
            return this.sessionCookieName;
        }

        public void setSessionNumberControl(Boolean sessionNumberControl) {
            this.sessionNumberControl = sessionNumberControl;
        }

        public void setMaximumSessions(Integer maximumSessions) {
            this.maximumSessions = maximumSessions;
        }

        public void setMaxSessionsPreventsLogin(Boolean maxSessionsPreventsLogin) {
            this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
        }

        public void setEnableSessionUrlRewriting(Boolean enableSessionUrlRewriting) {
            this.enableSessionUrlRewriting = enableSessionUrlRewriting;
        }

        public void setSessionCreationPolicy(SessionCreationPolicy sessionCreationPolicy) {
            this.sessionCreationPolicy = sessionCreationPolicy;
        }

        public void setInvalidSessionUrl(String invalidSessionUrl) {
            this.invalidSessionUrl = invalidSessionUrl;
        }

        public void setInvalidSessionOfConcurrentUrl(String invalidSessionOfConcurrentUrl) {
            this.invalidSessionOfConcurrentUrl = invalidSessionOfConcurrentUrl;
        }

        public void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }
    }
}

