/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.enums;

import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public enum PermissionType {
    GET("list", "\u67e5\u8be2\u6743\u9650"),
    POST("add", "\u6dfb\u52a0\u6743\u9650"),
    PUT("edit", "\u66f4\u65b0\u6743\u9650"),
    DELETE("delete", "\u5220\u9664\u6743\u9650"),
    HEAD("head", "HEAD\u6743\u9650"),
    PATCH("patch", "PATCH\u6743\u9650"),
    OPTIONS("options", "OPTIONS\u6743\u9650"),
    TRACE("trace", "TRACE\u6743\u9650");

    private final String description;
    private final String permission;
    private static volatile Set<String> permissions;

    private PermissionType(String permission, String description) {
        this.permission = permission;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPermission() {
        return this.permission;
    }

    @Nullable
    public static String getPermission(@NonNull HttpMethod method) {
        PermissionType permissionType = PermissionType.getPermissionType(method);
        if (permissionType == null) {
            return null;
        }
        return permissionType.getPermission();
    }

    @Nullable
    public static PermissionType getPermissionType(@NonNull HttpMethod method) {
        PermissionType[] types;
        for (PermissionType type : types = PermissionType.values()) {
            if (!type.name().equalsIgnoreCase(method.name())) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Set<String> getPermissions() {
        if (permissions != null) return permissions;
        Class<PermissionType> clazz = PermissionType.class;
        synchronized (PermissionType.class) {
            if (permissions != null) return permissions;
            PermissionType[] types = PermissionType.values();
            HashSet<String> permissionSet = new HashSet<String>(types.length);
            for (PermissionType type : types) {
                permissionSet.add(type.getPermission());
            }
            permissions = permissionSet;
            // ** MonitorExit[var0] (shouldn't be in output)
            return permissions;
        }
    }
}

