/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.exception.handler;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.vo.ResponseResult;

public class UmsAccessDeniedHandlerImpl
implements AccessDeniedHandler {
    private static final Logger log = LoggerFactory.getLogger(UmsAccessDeniedHandlerImpl.class);
    private String errorPage;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (response.isCommitted()) {
            log.trace("Did not write to response since already committed");
            return;
        }
        if (AuthenticationUtil.isAjaxOrJson(request)) {
            AuthenticationUtil.responseWithJson(response, HttpStatus.FORBIDDEN.value(), MvcUtil.toJsonString(ResponseResult.fail(ErrorCodeEnum.PERMISSION_DENY, request.getRequestURI())));
        }
        if (this.errorPage != null) {
            request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
            response.setStatus(HttpStatus.FORBIDDEN.value());
            RequestDispatcher dispatcher = request.getRequestDispatcher(this.errorPage);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            AuthenticationUtil.responseWithJson(response, HttpStatus.FORBIDDEN.value(), MvcUtil.toJsonString(ResponseResult.fail(ErrorCodeEnum.PERMISSION_DENY, request.getRequestURI())));
        }
    }

    public void setErrorPage(String errorPage) {
        if (errorPage != null && !errorPage.startsWith("/")) {
            throw new IllegalArgumentException("errorPage must begin with '/'");
        }
        this.errorPage = errorPage;
    }
}

