/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class MvcUtil {
    private static final Logger log = LoggerFactory.getLogger(MvcUtil.class);
    private static String servletContextPath = "";
    private static volatile UrlPathHelper urlPathHelper = null;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJsonString(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            String msg = String.format("Object2JsonString \u5931\u8d25: %s, Object=%s", e.getMessage(), obj);
            log.error(msg, (Throwable)e);
            return "";
        }
    }

    @Nullable
    public static <T> T json2Object(@NonNull String jsonString, @NonNull Class<T> clz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, clz);
        }
        catch (JsonProcessingException e) {
            log.error(String.format("[%s] \u53cd\u5e8f\u5217\u5316\u4e3a [%s] \u65f6\u9519\u8bef: %s", jsonString, clz.getName(), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UrlPathHelper getUrlPathHelper() {
        if (urlPathHelper != null) return urlPathHelper;
        Class<MvcUtil> clazz = MvcUtil.class;
        synchronized (MvcUtil.class) {
            if (urlPathHelper != null) return urlPathHelper;
            UrlPathHelper helper = new UrlPathHelper();
            helper.setAlwaysUseFullPath(true);
            urlPathHelper = helper;
            // ** MonitorExit[var0] (shouldn't be in output)
            return urlPathHelper;
        }
    }

    public static String getServletContextPath() {
        return servletContextPath;
    }

    private static void unregisterController(@NonNull String controllerBeanName, @NonNull GenericApplicationContext applicationContext) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping");
        Object controller = applicationContext.getBean(controllerBeanName);
        Class<?> targetClass = controller.getClass();
        ReflectionUtils.doWithMethods(targetClass, method -> {
            Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
            try {
                Method createMappingMethod = RequestMappingHandlerMapping.class.getDeclaredMethod("getMappingForMethod", Method.class, Class.class);
                createMappingMethod.setAccessible(true);
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)createMappingMethod.invoke((Object)requestMappingHandlerMapping, specificMethod, targetClass);
                if (requestMappingInfo != null) {
                    requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
    }

    public static void registerController(@NonNull String controllerBeanName, @NonNull GenericApplicationContext applicationContext, @Nullable Class<?> clz) throws Exception {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping");
        try {
            applicationContext.getBean(controllerBeanName);
        }
        catch (Exception e) {
            if (clz != null) {
                Object bean = applicationContext.getBean(clz);
                log.info("{} \u6ca1\u6709\u5728 IOC \u5bb9\u5668\u4e2d, \u5df2\u88ab {} \u66ff\u4ee3, \u65e0\u987b\u518d\u505a Uri \u6620\u5c04", (Object)controllerBeanName, (Object)bean.getClass().getName());
                return;
            }
            throw e;
        }
        MvcUtil.unregisterController(controllerBeanName, applicationContext);
        Method method = requestMappingHandlerMapping.getClass().getSuperclass().getSuperclass().getDeclaredMethod("detectHandlerMethods", Object.class);
        method.setAccessible(true);
        method.invoke((Object)requestMappingHandlerMapping, controllerBeanName);
        log.info("{} \u5728 mvc \u4e2d\u505a Uri \u6620\u5c04\u7b49\u52a8\u4f5c\u6210\u529f", (Object)controllerBeanName);
    }

    public static void setRequestMappingUri(@NonNull String methodName, @NonNull String requestMappingUri, @NonNull Class<?> clz, Class<?> ... parameterTypes) throws Exception {
        Method method = clz.getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        RequestMapping mappingAnnotation = method.getDeclaredAnnotation(RequestMapping.class);
        if (null != mappingAnnotation) {
            String[] paths = mappingAnnotation.value();
            if (paths.length > 0) {
                paths[0] = requestMappingUri;
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(mappingAnnotation);
                Field memberValuesField = invocationHandler.getClass().getDeclaredField("memberValues");
                memberValuesField.setAccessible(true);
                Map memberValuesValue = (Map)memberValuesField.get(invocationHandler);
                memberValuesValue.put("value", paths);
            }
        } else {
            String msg = String.format("\u8bbe\u7f6e %s#%s() \u65b9\u6cd5\u7684 requestMapping \u6620\u5c04\u503c\u65f6\u53d1\u751f\u9519\u8bef.", clz.getName(), methodName);
            throw new RuntimeException(msg);
        }
    }

    public static void setScheduledCron(@NonNull String methodName, @NonNull String cronValue, @NonNull Class<?> targetClass, Class<?> ... parameterTypes) throws Exception {
        Method method = targetClass.getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        Scheduled annotation = method.getDeclaredAnnotation(Scheduled.class);
        if (null == annotation) {
            String msg = String.format("\u8bbe\u7f6e %s#%s() \u65b9\u6cd5\u7684 cron \u6620\u5c04\u503c\u65f6\u53d1\u751f\u9519\u8bef.", targetClass.getName(), methodName);
            throw new RuntimeException(msg);
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        Field memberValuesField = invocationHandler.getClass().getDeclaredField("memberValues");
        memberValuesField.setAccessible(true);
        Map memberValuesValue = (Map)memberValuesField.get(invocationHandler);
        memberValuesValue.put("cron", cronValue);
    }

    public static void registerDelegateApplicationListener(ApplicationContext applicationContext, ApplicationListener<?> delegate) {
        if (applicationContext.getBeansOfType(DelegatingApplicationListener.class).isEmpty()) {
            return;
        }
        DelegatingApplicationListener delegating = (DelegatingApplicationListener)applicationContext.getBean(DelegatingApplicationListener.class);
        GenericApplicationListenerAdapter smartListener = new GenericApplicationListenerAdapter(delegate);
        delegating.addListener((SmartApplicationListener)smartListener);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

