/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.permission.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.permission.enums.PermissionType;
import top.dcenter.ums.security.core.util.MvcUtil;

public abstract class AbstractUriAuthorizeService
implements UriAuthorizeService {
    public static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    public static final String DEFAULT_TENANT_PREFIX = "TENANT_";
    public static final String DEFAULT_SCOPE_PREFIX = "SCOPE_";
    public static final String PERMISSION_DELIMITER = ",";
    protected AntPathMatcher antPathMatcher = new AntPathMatcher();

    @Override
    public boolean hasPermission(Authentication authentication, HttpServletRequest request) {
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        String method = request.getMethod();
        Predicate<Map.Entry<String, Set<String>>> predicate = entry -> this.isMatchByMethod(method, (Set)entry.getValue());
        return this.hasPermission(authentication, requestUri, predicate);
    }

    @Override
    public boolean hasPermission(Authentication authentication, String requestUri, String permission) {
        Predicate<Map.Entry<String, Set<String>>> predicate = entry -> ((Set)entry.getValue()).contains(permission);
        return this.hasPermission(authentication, requestUri, predicate);
    }

    private boolean hasPermission(Authentication authentication, String requestUri, Predicate<Map.Entry<String, Set<String>>> predicate) {
        Map<String, Set<String>> uriPermissionsOfUser = this.getUriAuthoritiesOfUser(authentication);
        return uriPermissionsOfUser.entrySet().stream().filter(entry -> this.antPathMatcher.match((String)entry.getKey(), requestUri)).anyMatch(predicate);
    }

    @Override
    @NonNull
    public Map<String, Set<String>> getUriAuthoritiesOfUser(@NonNull Authentication authentication) {
        Set authoritySet = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
        int size = authoritySet.size();
        HashSet<String> roleSet = new HashSet<String>(size);
        String[] tenantAuthority = new String[]{null};
        HashSet<String> scopeSet = new HashSet<String>(size);
        authoritySet.forEach(authority -> {
            if (authority.startsWith(DEFAULT_ROLE_PREFIX)) {
                roleSet.add((String)authority);
            } else if (authority.startsWith(DEFAULT_TENANT_PREFIX)) {
                tenantAuthority[0] = authority;
            } else if (authority.startsWith(DEFAULT_SCOPE_PREFIX)) {
                scopeSet.add((String)authority);
            }
        });
        Map<String, Map<String, Set<String>>> rolesAuthorities = null == tenantAuthority[0] ? this.getRolesAuthorities() : this.getRolesAuthoritiesOfTenant(tenantAuthority[0]);
        Map<String, Set<String>> uriPermissionsOfUserRole = this.getUriAuthoritiesOfUserRole(rolesAuthorities, roleSet);
        if (scopeSet.size() > 0) {
            Map<String, Map<String, Set<String>>> uriPermissionsOfScope = this.getScopeAuthoritiesOfScope(scopeSet);
            uriPermissionsOfScope.values().forEach(this.map2mapConsumer(uriPermissionsOfUserRole));
        }
        return uriPermissionsOfUserRole;
    }

    @NonNull
    private Map<String, Set<String>> getUriAuthoritiesOfUserRole(Map<String, Map<String, Set<String>>> rolesAuthoritiesMap, Set<String> userRoleSet) {
        HashMap<String, Set<String>> uriAuthoritiesMap = new HashMap<String, Set<String>>(rolesAuthoritiesMap.size());
        rolesAuthoritiesMap.entrySet().stream().filter(entry -> userRoleSet.contains(entry.getKey())).map(Map.Entry::getValue).forEach(this.map2mapConsumer(uriAuthoritiesMap));
        return uriAuthoritiesMap;
    }

    @NonNull
    private Consumer<Map<String, Set<String>>> map2mapConsumer(Map<String, Set<String>> uriAuthoritiesMap) {
        return map -> map.forEach((key, value) -> uriAuthoritiesMap.compute((String)key, (k, v) -> {
            if (v == null) {
                v = new HashSet();
            }
            v.addAll(value);
            return v;
        }));
    }

    private boolean isMatchByMethod(@NonNull String requestMethod, @Nullable Set<String> userPermissionSet) {
        if (CollectionUtils.isEmpty(userPermissionSet)) {
            return false;
        }
        String permission = PermissionType.getPermission(HttpMethod.valueOf((String)requestMethod));
        if (permission == null) {
            return false;
        }
        return userPermissionSet.stream().anyMatch(authority -> authority.equals(permission));
    }

    @Override
    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }
}

