/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.image;

import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeCacheType;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCode;
import top.dcenter.ums.security.core.util.IpUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public class ImageValidateCodeProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(ImageValidateCodeProcessor.class);

    public ImageValidateCodeProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeCacheType validateCodeCacheType, @Nullable RedisConnectionFactory redisConnectionFactory) {
        super(validateCodeGeneratorHolder, validateCodeCacheType, ImageCode.class, redisConnectionFactory);
    }

    @Override
    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        try {
            if (!(validateCode instanceof ImageCode)) {
                return false;
            }
            ImageCode imageCode = (ImageCode)validateCode;
            HttpServletResponse response = request.getResponse();
            if (response == null) {
                return false;
            }
            response.setContentType("image/png");
            try (FileChannel fileChannel = FileChannel.open(Paths.get(imageCode.getImageUrl(), new String[0]), StandardOpenOption.READ);
                 WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)response.getOutputStream());){
                fileChannel.transferTo(0L, fileChannel.size(), writableByteChannel);
            }
            return true;
        }
        catch (Exception e) {
            HttpServletRequest req = request.getRequest();
            log.error(String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, sid=%s, uri=%s, validateCode=%s", e.getMessage(), IpUtil.getRealIp(req), request.getSessionId(), MvcUtil.getServletContextPath() + req.getRequestURI(), validateCode.toString()), (Throwable)e);
            return false;
        }
    }

    @Override
    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.IMAGE;
    }
}

