/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.slider;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCode;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.IpUtil;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class SliderCoderProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SliderCoderProcessor.class);
    private final ValidateCodeProperties validateCodeProperties;

    public SliderCoderProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeProperties validateCodeProperties, @Nullable RedisConnectionFactory redisConnectionFactory) {
        super(validateCodeGeneratorHolder, validateCodeProperties.getValidateCodeCacheType(), SliderCode.class, redisConnectionFactory);
        this.validateCodeProperties = validateCodeProperties;
    }

    @Override
    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        try {
            if (!(validateCode instanceof SliderCode)) {
                return false;
            }
            SliderCode sliderCode = (SliderCode)validateCode;
            HttpServletResponse response = request.getResponse();
            if (response == null) {
                return false;
            }
            String resultJson = MvcUtil.toJsonString(sliderCode);
            AuthenticationUtil.responseWithJson(response, HttpStatus.OK.value(), resultJson);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u6ed1\u5757\u9a8c\u8bc1\u7801: sliderCode = {}", (Object)sliderCode.toString());
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.SLIDER;
    }

    @Override
    public void validate(ServletWebRequest request) throws ValidateCodeException {
        boolean verify;
        HttpServletRequest req = request.getRequest();
        ValidateCodeType sliderType = ValidateCodeType.SLIDER;
        SliderCode sliderCodeInSession = (SliderCode)this.validateCodeCacheType.getCodeInCache(request, sliderType, SliderCode.class, this.redisConnectionFactory);
        if (sliderCodeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_NOT_EXISTS_IN_CACHE, IpUtil.getRealIp(req), request.getSessionId());
        }
        if (sliderCodeInSession.getSecondCheck().booleanValue()) {
            this.defaultValidate(request, this.validateCodeProperties.getSlider().getTokenRequestParamName(), SliderCode.class, this.validateCodeCacheType, this.redisConnectionFactory);
            return;
        }
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        String tokenRequestParamName = slider.getTokenRequestParamName();
        String xRequestParamName = slider.getXRequestParamName();
        String yRequestParamName = slider.getYRequestParamName();
        String token = request.getParameter(tokenRequestParamName);
        String x = request.getParameter(xRequestParamName);
        String y = request.getParameter(yRequestParamName);
        this.checkParam(sliderType, request, !StringUtils.hasText((String)token), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, tokenRequestParamName, sliderCodeInSession);
        this.checkParam(sliderType, request, !StringUtils.hasText((String)x), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, xRequestParamName, sliderCodeInSession);
        this.checkParam(sliderType, request, !StringUtils.hasText((String)y), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, yRequestParamName, sliderCodeInSession);
        token = token.trim();
        Integer locationX = Integer.parseInt(x);
        Integer locationY = Integer.parseInt(y);
        this.checkParam(sliderType, request, sliderCodeInSession.isExpired(), ErrorCodeEnum.VALIDATE_CODE_EXPIRED, token, sliderCodeInSession);
        boolean bl = verify = sliderCodeInSession.getLocationY().equals(locationY) && Math.abs(sliderCodeInSession.getLocationX() - locationX) < 2;
        if (!verify) {
            if (!sliderCodeInSession.getReuse().booleanValue()) {
                this.validateCodeCacheType.removeCache(request, sliderType, this.redisConnectionFactory);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_FAILURE, IpUtil.getRealIp(req), token);
        }
        sliderCodeInSession.setSecondCheck(true);
        sliderCodeInSession.setCode(ValidateCodeUtil.getUuid());
        sliderCodeInSession.setReuse(false);
        this.validateCodeCacheType.save(request, sliderCodeInSession, sliderType, this.redisConnectionFactory);
    }

    private void checkParam(ValidateCodeType sliderType, ServletWebRequest request, boolean condition, ErrorCodeEnum errorCodeEnum, String errorData, SliderCode sliderCode) throws ValidateCodeException {
        if (condition) {
            if (sliderCode.getReuse().booleanValue()) {
                this.validateCodeCacheType.removeCache(request, sliderType, this.redisConnectionFactory);
            }
            throw new ValidateCodeException(errorCodeEnum, IpUtil.getRealIp(request.getRequest()), errorData);
        }
    }
}

