/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.api.mdc.MdcIdGenerator;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.mdc.MdcIdType;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public class MdcLogFilter
extends OncePerRequestFilter {
    public static final String MDC_KEY = "MDC_TRACE_ID";
    @Autowired(required=false)
    private MdcIdGenerator mdcIdGenerator;
    private final Set<String> includeUrls;
    private final Set<String> excludeUrls;
    private final AntPathMatcher matcher;
    private final MdcIdType idType;

    public MdcLogFilter(MdcProperties mdcProperties, ClientProperties clientProperties) {
        Set<String> excludeUrls;
        this.idType = mdcProperties.getType();
        this.matcher = new AntPathMatcher();
        this.includeUrls = new HashSet<String>();
        this.excludeUrls = new HashSet<String>();
        this.includeUrls.addAll(mdcProperties.getIncludeUrls());
        String[] ignoringUrls = clientProperties.getIgnoringUrls();
        if (null != ignoringUrls) {
            this.excludeUrls.addAll(Arrays.asList(ignoringUrls));
        }
        if (null != (excludeUrls = mdcProperties.getExcludeUrls())) {
            this.excludeUrls.addAll(excludeUrls);
        }
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (this.isEnableMdc(request)) {
            String token = MdcUtil.getMdcId(this.idType, this.mdcIdGenerator);
            MDC.put((String)MDC_KEY, (String)token);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            MDC.clear();
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isEnableMdc(HttpServletRequest request) {
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        for (String excludeUrl : this.excludeUrls) {
            if (!this.matcher.match(excludeUrl, requestUri)) continue;
            return false;
        }
        for (String includeUrl : this.includeUrls) {
            if (!this.matcher.match(includeUrl, requestUri)) continue;
            return true;
        }
        return false;
    }
}

