/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.filter.redirect;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.core.api.oauth.state.service.Auth2StateCoder;
import top.dcenter.ums.security.core.exception.Auth2Exception;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2DefaultRequestResolver;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.vo.RedirectVo;

public class Auth2DefaultRequestRedirectFilter
extends OncePerRequestFilter {
    private final ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private final RedirectStrategy authorizationRedirectStrategy = new DefaultRedirectStrategy();
    private final Auth2DefaultRequestResolver authorizationRequestResolver;
    private final Auth2StateCoder auth2StateCoder;
    private final SimpleUrlAuthenticationFailureHandler authenticationFailureHandler;
    private RequestCache requestCache = new HttpSessionRequestCache();

    public Auth2DefaultRequestRedirectFilter(@NonNull String authorizationRequestBaseUri, @Nullable Auth2StateCoder auth2StateCoder, @NonNull SimpleUrlAuthenticationFailureHandler authenticationFailureHandler) {
        Assert.hasText((String)authorizationRequestBaseUri, (String)"authorizationRequestBaseUri cannot be empty");
        this.authorizationRequestResolver = new Auth2DefaultRequestResolver(authorizationRequestBaseUri);
        this.auth2StateCoder = auth2StateCoder;
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public Auth2DefaultRequestRedirectFilter(@NonNull Auth2DefaultRequestResolver authorizationRequestResolver, @Nullable Auth2StateCoder auth2StateCoder, @NonNull SimpleUrlAuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authorizationRequestResolver, (String)"authorizationRequestResolver cannot be null");
        this.authorizationRequestResolver = authorizationRequestResolver;
        this.auth2StateCoder = auth2StateCoder;
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public final void setRequestCache(RequestCache requestCache) {
        Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
        this.requestCache = requestCache;
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            Auth2DefaultRequest authorizationRequest = this.authorizationRequestResolver.resolve(request);
            if (authorizationRequest != null) {
                this.sendRedirectForAuthorization(request, response, authorizationRequest);
                return;
            }
        }
        catch (Auth2Exception ex) {
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
            return;
        }
        catch (Exception ex) {
            this.unsuccessfulRedirectForAuthorization(request, response, ex);
            return;
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
            ClientAuthorizationRequiredException authzEx = (ClientAuthorizationRequiredException)this.throwableAnalyzer.getFirstThrowableOfType(ClientAuthorizationRequiredException.class, causeChain);
            if (authzEx != null) {
                try {
                    Auth2DefaultRequest authorizationRequest = this.authorizationRequestResolver.resolve(request, authzEx.getClientRegistrationId());
                    if (authorizationRequest == null) {
                        throw authzEx;
                    }
                    this.sendRedirectForAuthorization(request, response, authorizationRequest);
                    this.requestCache.saveRequest(request, response);
                }
                catch (Exception failed) {
                    this.unsuccessfulRedirectForAuthorization(request, response, failed);
                }
                return;
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private void sendRedirectForAuthorization(HttpServletRequest request, HttpServletResponse response, Auth2DefaultRequest authorizationRequest) throws IOException {
        String state = authorizationRequest.generateState();
        if (this.auth2StateCoder != null) {
            state = this.auth2StateCoder.encode(state, request);
        }
        String authorize = authorizationRequest.authorize(state);
        if (AuthenticationUtil.isAjaxOrJson(request)) {
            AuthenticationUtil.responseWithJson(response, HttpStatus.OK.value(), MvcUtil.toJsonString(RedirectVo.redirect(authorize)));
            return;
        }
        this.authorizationRedirectStrategy.sendRedirect(request, response, authorize);
    }

    private void unsuccessfulRedirectForAuthorization(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.logger.error((Object)LogMessage.format((String)"Authorization Request failed: %s", (Object)ex, (Object)ex));
        response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    private static final class DefaultThrowableAnalyzer
    extends ThrowableAnalyzer {
        private DefaultThrowableAnalyzer() {
        }

        protected void initExtractorMap() {
            super.initExtractorMap();
            this.registerExtractor(ServletException.class, throwable -> {
                ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, ServletException.class);
                return ((ServletException)throwable).getRootCause();
            });
        }
    }
}

