/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.zhyd.oauth.cache.AuthDefaultStateCache;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.request.AuthDefaultRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateRedisCache;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateSessionCache;
import top.dcenter.ums.security.core.oauth.justauth.enums.StateCacheType;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.AuthDefaultRequestAdapter;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.BaseAuth2Properties;
import top.dcenter.ums.security.core.oauth.properties.JustAuthProperties;
import top.dcenter.ums.security.core.util.ConvertUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public class Auth2RequestHolder
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(Auth2RequestHolder.class);
    private static final String FIELD_SEPARATOR = "_";
    private static final String CLIENT_ID_FIELD_NAME = "clientId";
    private static final String CLIENT_SECRET_FIELD_NAME = "clientSecret";
    private static final String PROVIDER_ID_FIELD_NAME = "providerId";
    private static final Map<String, Auth2DefaultRequest> PROVIDER_ID_AUTH_REQUEST_MAP = new ConcurrentHashMap<String, Auth2DefaultRequest>();
    private static final Map<AuthDefaultSource, String> SOURCE_PROVIDER_ID_MAP = new ConcurrentHashMap<AuthDefaultSource, String>();
    private ApplicationContext applicationContext;
    public static final String AUTH_REQUEST_PACKAGE = "me.zhyd.oauth.request.";
    public static final String AUTH_REQUEST_PREFIX = "Auth";
    public static final String AUTH_REQUEST_SUFFIX = "Request";

    @Nullable
    public static Auth2DefaultRequest getAuth2DefaultRequest(String providerId) {
        if (PROVIDER_ID_AUTH_REQUEST_MAP.size() < 1 || providerId == null) {
            return null;
        }
        return PROVIDER_ID_AUTH_REQUEST_MAP.get(providerId);
    }

    public static String getProviderId(AuthDefaultSource source) {
        if (SOURCE_PROVIDER_ID_MAP.size() < 1 || null == source) {
            return null;
        }
        return SOURCE_PROVIDER_ID_MAP.get(source);
    }

    public static Collection<String> getProviderIds() {
        return SOURCE_PROVIDER_ID_MAP.values();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Field[] declaredFields;
        AuthStateCache authStateCache;
        Auth2Properties auth2Properties = (Auth2Properties)this.applicationContext.getBean(Auth2Properties.class);
        JustAuthProperties justAuthProperties = auth2Properties.getJustAuth();
        StateCacheType stateCacheType = justAuthProperties.getCacheType();
        if (stateCacheType.equals((Object)StateCacheType.REDIS)) {
            Class<?> stringRedisTemplateClass = Class.forName("org.springframework.data.redis.core.StringRedisTemplate");
            Object stringRedisTemplate = this.applicationContext.getBean(stringRedisTemplateClass);
            authStateCache = this.getAuthStateCache(stateCacheType, auth2Properties, stringRedisTemplate);
        } else {
            authStateCache = this.getAuthStateCache(stateCacheType, auth2Properties, null);
        }
        Class<Auth2Properties> aClass = Auth2Properties.class;
        for (Field field : declaredFields = aClass.getDeclaredFields()) {
            Auth2DefaultRequest auth2DefaultRequest;
            field.setAccessible(true);
            Auth2Properties oriAuth2Properties = (Auth2Properties)AopProxyUtils.getSingletonTarget((Object)auth2Properties);
            Object baseProperties = field.get(oriAuth2Properties);
            if (!(baseProperties instanceof BaseAuth2Properties)) continue;
            String providerId = field.getName();
            CharSequence[] splits = ConvertUtil.splitByCharacterTypeCamelCase(providerId, true);
            AuthDefaultSource source = AuthDefaultSource.valueOf((String)String.join((CharSequence)FIELD_SEPARATOR, splits).toUpperCase());
            SOURCE_PROVIDER_ID_MAP.put(source, providerId);
            BaseAuth2Properties baseAuth2Properties = (BaseAuth2Properties)baseProperties;
            if (baseAuth2Properties.getClientId() == null || baseAuth2Properties.getClientSecret() == null || null == (auth2DefaultRequest = this.getAuth2DefaultRequest(source, oriAuth2Properties, authStateCache))) continue;
            PROVIDER_ID_AUTH_REQUEST_MAP.put(providerId, auth2DefaultRequest);
        }
    }

    @Nullable
    private Auth2DefaultRequest getAuth2DefaultRequest(@NonNull AuthDefaultSource source, @NonNull Auth2Properties auth2Properties, @NonNull AuthStateCache authStateCache) throws IllegalAccessException, ClassNotFoundException {
        JustAuthProperties justAuth = auth2Properties.getJustAuth();
        AuthConfig config = this.getAuthConfig(auth2Properties, source);
        config.setScopes(justAuth.getScopes());
        Auth2Properties.HttpConfigProperties proxy = auth2Properties.getProxy();
        config.setHttpConfig(proxy.getHttpConfig());
        config.setIgnoreCheckState(justAuth.getIgnoreCheckState().booleanValue());
        boolean isNotSupport = false;
        switch (source) {
            case CODING: {
                config.setCodingGroupName(auth2Properties.getCoding().getCodingGroupName());
                break;
            }
            case ALIPAY: {
                config.setAlipayPublicKey(auth2Properties.getAlipay().getAlipayPublicKey());
                break;
            }
            case QQ: {
                config.setUnionId(auth2Properties.getQq().getUnionId().booleanValue());
                break;
            }
            case WECHAT_ENTERPRISE: {
                config.setAgentId(auth2Properties.getWechatEnterprise().getAgentId());
                break;
            }
            case STACK_OVERFLOW: {
                config.setStackOverflowKey(auth2Properties.getStackOverflow().getStackOverflowKey());
            }
            case GITHUB: 
            case GOOGLE: 
            case FACEBOOK: 
            case MICROSOFT: 
            case PINTEREST: 
            case GITLAB: 
            case TWITTER: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                break;
            }
            case CSDN: 
            case FEISHU: {
                isNotSupport = true;
                break;
            }
        }
        if (isNotSupport) {
            return null;
        }
        return this.getAuthDefaultRequestAdapter(config, source, authStateCache);
    }

    @NonNull
    private AuthDefaultRequestAdapter getAuthDefaultRequestAdapter(@NonNull AuthConfig config, @NonNull AuthDefaultSource source, @NonNull AuthStateCache authStateCache) throws ClassNotFoundException {
        AuthDefaultRequestAdapter adapter = new AuthDefaultRequestAdapter(config, source, authStateCache);
        Class[] argumentTypes = new Class[]{AuthConfig.class, AuthStateCache.class};
        Object[] arguments = new Object[]{config, authStateCache};
        AuthDefaultRequest proxyObject = this.createProxy(Auth2RequestHolder.getAuthRequestClassBySource(source), argumentTypes, arguments, adapter);
        adapter.setAuthDefaultRequest(proxyObject);
        return adapter;
    }

    @NonNull
    private AuthDefaultRequest createProxy(Class<?> targetClass, Class<?>[] argumentTypes, Object[] arguments, AuthDefaultRequestAdapter adapter) throws ClassNotFoundException {
        if (!AuthDefaultRequest.class.isAssignableFrom(targetClass)) {
            throw new ClassNotFoundException(targetClass.getName() + " \u5fc5\u987b\u662f me.zhyd.oauth.request.AuthDefaultRequest \u7684\u5b50\u7c7b");
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setCallback((Callback)((MethodInterceptor)(target, method, args, methodProxy) -> {
            if (target instanceof AuthDefaultRequest && !(target instanceof AuthDefaultRequestAdapter) && "getRealState".equals(method.getName())) {
                return adapter.getRealState((String)args[0]);
            }
            return methodProxy.invokeSuper(target, args);
        }));
        return (AuthDefaultRequest)enhancer.create((Class[])argumentTypes, arguments);
    }

    private AuthStateCache getAuthStateCache(StateCacheType type, Auth2Properties auth2Properties, Object stringRedisTemplate) {
        switch (type) {
            case DEFAULT: {
                return AuthDefaultStateCache.INSTANCE;
            }
            case SESSION: {
                return new AuthStateSessionCache(auth2Properties);
            }
            case REDIS: {
                if (stringRedisTemplate == null) {
                    throw new RuntimeException(String.format("applicationContext \u4e2d\u83b7\u53d6\u4e0d\u5230 %s, %s \u7c7b\u578b\u7684\u7f13\u5b58\u65e0\u6cd5\u521b\u5efa!", "org.springframework.data.redis.core.StringRedisTemplate", type.name()));
                }
                return new AuthStateRedisCache(auth2Properties, stringRedisTemplate);
            }
        }
        log.error("{} \u7c7b\u578b\u4e0d\u5339\u914d, \u4f7f\u7528 {} \u7c7b\u578b\u7f13\u5b58\u66ff\u4ee3", (Object)StateCacheType.class.getName(), (Object)StateCacheType.DEFAULT.name());
        return AuthDefaultStateCache.INSTANCE;
    }

    private AuthConfig getAuthConfig(@NonNull Auth2Properties auth2Properties, @NonNull AuthDefaultSource source) throws IllegalAccessException, NullPointerException {
        AuthConfig.AuthConfigBuilder builder = AuthConfig.builder();
        String fieldName = Auth2RequestHolder.getProviderId(source);
        Class<?> aClass = auth2Properties.getClass();
        Field[] declaredFields = aClass.getDeclaredFields();
        Object providerProperties = null;
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            providerProperties = field.get(auth2Properties);
            break;
        }
        String providerId = "";
        Objects.requireNonNull(providerProperties, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 BaseAuth2Properties \u7684\u5b50\u7c7b", source.name()));
        for (Field field : declaredFields = providerProperties.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!PROVIDER_ID_FIELD_NAME.equals(field.getName())) continue;
            providerId = (String)field.get(providerProperties);
            Objects.requireNonNull(providerId, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), PROVIDER_ID_FIELD_NAME));
        }
        Class<BaseAuth2Properties> baseClass = BaseAuth2Properties.class;
        for (Field field : declaredFields = baseClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (CLIENT_ID_FIELD_NAME.equals(field.getName())) {
                String clientId = (String)field.get(providerProperties);
                Objects.requireNonNull(clientId, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), CLIENT_ID_FIELD_NAME));
                builder.clientId(clientId);
            }
            if (!CLIENT_SECRET_FIELD_NAME.equals(field.getName())) continue;
            String clientSecret = (String)field.get(providerProperties);
            Objects.requireNonNull(clientSecret, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), CLIENT_SECRET_FIELD_NAME));
            builder.clientSecret(clientSecret);
        }
        String redirectUri = auth2Properties.getDomain() + MvcUtil.getServletContextPath() + auth2Properties.getRedirectUrlPrefix() + "/" + providerId;
        return builder.redirectUri(redirectUri).build();
    }

    public static String getProviderIdBySource(@NonNull AuthDefaultSource source) {
        String[] splits = source.name().split(FIELD_SEPARATOR);
        return Auth2RequestHolder.toProviderId(splits);
    }

    @NonNull
    public static Class<?> getAuthRequestClassBySource(@NonNull AuthDefaultSource source) throws ClassNotFoundException {
        String[] splits = source.name().split(FIELD_SEPARATOR);
        String authRequestClassName = AUTH_REQUEST_PACKAGE + Auth2RequestHolder.toAuthRequestClassName(splits);
        return Class.forName(authRequestClassName);
    }

    @NonNull
    private static String toAuthRequestClassName(String[] splits) {
        StringBuilder sb = new StringBuilder();
        sb.append(AUTH_REQUEST_PREFIX);
        for (String split : splits) {
            split = split.toLowerCase();
            if (AuthDefaultSource.DINGTALK.name().equalsIgnoreCase(split)) {
                sb.append("DingTalk");
                continue;
            }
            if ("wechat".equalsIgnoreCase(split)) {
                sb.append("WeChat");
                continue;
            }
            if (split.length() > 1) {
                sb.append(split.substring(0, 1).toUpperCase()).append(split.substring(1));
                continue;
            }
            sb.append(split.toUpperCase());
        }
        sb.append(AUTH_REQUEST_SUFFIX);
        return sb.toString();
    }

    @NonNull
    private static String toProviderId(String[] splits) {
        StringBuilder sb = new StringBuilder();
        for (String split : splits) {
            if ((split = split.toLowerCase()).length() > 1) {
                sb.append(split.substring(0, 1).toUpperCase()).append(split.substring(1));
                continue;
            }
            sb.append(split.toUpperCase());
        }
        String firstChar = String.valueOf(sb.charAt(0)).toLowerCase();
        sb.replace(0, 1, firstChar);
        return sb.toString();
    }
}

