/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.jackson.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationToken;

public class SmsCodeLoginAuthenticationTokenJsonDeserializer
extends StdDeserializer<SmsCodeLoginAuthenticationToken> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SmsCodeLoginAuthenticationTokenJsonDeserializer() {
        super(SmsCodeLoginAuthenticationToken.class);
    }

    public SmsCodeLoginAuthenticationToken deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object principal;
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        Collection tokenAuthorities = (Collection)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Collection<SimpleGrantedAuthority>>(){});
        boolean authenticated = jsonNode.get("authenticated").asBoolean();
        JsonNode detailsNode = jsonNode.get("details");
        JsonNode principalNode = jsonNode.get("principal");
        String principalString = principalNode.toString();
        String principalClassName = principalString.substring(1);
        principalClassName = principalClassName.startsWith("\"@class\":\"") ? principalClassName.substring(principalClassName.indexOf("\"@class\":\"") + 10) : principalClassName.substring(1);
        principalClassName = principalClassName.substring(0, principalClassName.indexOf("\""));
        try {
            Class<?> principalClass = Class.forName(principalClassName);
            JavaType javaType = mapper.getTypeFactory().constructType(principalClass);
            principal = mapper.convertValue((Object)principalNode, javaType);
        }
        catch (Exception e) {
            String msg = String.format("SmsCodeLoginAuthenticationToken Jackson \u53cd\u5e8f\u5217\u5316\u9519\u8bef: principal \u53cd\u5e8f\u5217\u5316\u9519\u8bef: %s", principalNode.toString());
            throw new IOException(msg, e);
        }
        SmsCodeLoginAuthenticationToken token = authenticated ? new SmsCodeLoginAuthenticationToken(principal, tokenAuthorities) : new SmsCodeLoginAuthenticationToken(principal.toString());
        token.eraseCredentials();
        if (!detailsNode.isNull() && !detailsNode.isMissingNode()) {
            WebAuthenticationDetails details = (WebAuthenticationDetails)mapper.convertValue((Object)detailsNode, (TypeReference)new TypeReference<WebAuthenticationDetails>(){});
            token.setDetails(details);
        }
        return token;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=SmsCodeLoginAuthenticationTokenJsonDeserializer.class)
    public static interface SmsCodeLoginAuthenticationTokenMixin {
    }
}

