/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.config;

import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.mdc.config.MdcPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.mdc.filter.MdcLogFilter;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;

@Configuration
@AutoConfigureAfter(value={MdcPropertiesAutoConfiguration.class})
public class MdcLogAutoConfigurerAware
implements HttpSecurityAware {
    private final MdcProperties mdcProperties;
    private final ClientProperties clientProperties;

    public MdcLogAutoConfigurerAware(MdcProperties mdcProperties, ClientProperties clientProperties) {
        this.mdcProperties = mdcProperties;
        this.clientProperties = clientProperties;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) {
    }

    public void preConfigure(HttpSecurity http) {
    }

    public void postConfigure(HttpSecurity http) {
        if (this.mdcProperties.getEnable().booleanValue()) {
            http.addFilterBefore((Filter)new MdcLogFilter(this.mdcProperties, this.clientProperties), WebAsyncManagerIntegrationFilter.class);
        }
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        return null;
    }
}

