/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.time.Duration;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.NonNull;
import org.springframework.security.jackson2.CoreJackson2Module;
import org.springframework.security.web.jackson2.WebJackson2Module;
import top.dcenter.ums.security.core.jackson2.Auth2Jackson2Module;
import top.dcenter.ums.security.core.oauth.properties.RedisCacheProperties;
import top.dcenter.ums.security.core.oauth.repository.jdbc.cache.RedisHashCacheManager;
import top.dcenter.ums.security.core.oauth.repository.jdbc.key.generator.RemoveConnectionsByConnectionKeyWithUserIdKeyGenerator;

@Configuration
@ConditionalOnProperty(prefix="ums.cache.redis", name={"open"}, havingValue="true")
@EnableCaching
public class RedisCacheAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheAutoConfiguration.class);
    public static final String REDIS_CACHE_HASH_KEY_SEPARATE = "__";
    public static final String REDIS_CACHE_KEY_SEPARATE = ":";
    public static final String USER_CONNECTION_CACHE_NAME = "UCC";
    public static final String USER_CONNECTION_HASH_CACHE_NAME = "UCHC";
    public static final String USER_CONNECTION_HASH_ALL_CLEAR_CACHE_NAME = "UCHACC";
    private final RedisCacheProperties redisCacheProperties;
    private final RedisProperties redisProperties;
    private static Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = RedisCacheAutoConfiguration.getJackson2JsonRedisSerializer();

    public RedisCacheAutoConfiguration(RedisCacheProperties redisCacheProperties, RedisProperties redisProperties) {
        this.redisCacheProperties = redisCacheProperties;
        Set<String> cacheNames = redisCacheProperties.getCache().getCacheNames();
        cacheNames.add(USER_CONNECTION_CACHE_NAME);
        cacheNames.add(USER_CONNECTION_HASH_CACHE_NAME);
        cacheNames.add(USER_CONNECTION_HASH_ALL_CLEAR_CACHE_NAME);
        this.redisProperties = redisProperties;
    }

    private static Jackson2JsonRedisSerializer getJackson2JsonRedisSerializer() {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.registerModules(new Module[]{new CoreJackson2Module(), new WebJackson2Module(), new Auth2Jackson2Module()});
        jackson2JsonRedisSerializer.setObjectMapper(om);
        return jackson2JsonRedisSerializer;
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(int dbIndex, String hostName, int port, String password, int maxIdle, int minIdle, int maxActive, Long maxWait, Long timeOut, Duration shutdownTimeOut) {
        RedisStandaloneConfiguration redisConfiguration = new RedisStandaloneConfiguration(hostName, port);
        redisConfiguration.setDatabase(dbIndex);
        redisConfiguration.setPassword(password);
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(maxIdle);
        genericObjectPoolConfig.setMinIdle(minIdle);
        genericObjectPoolConfig.setMaxTotal(maxActive);
        genericObjectPoolConfig.setMaxWaitMillis(maxWait.longValue());
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(timeOut));
        builder.shutdownTimeout(shutdownTimeOut);
        builder.poolConfig(genericObjectPoolConfig);
        LettucePoolingClientConfiguration lettuceClientConfiguration = builder.build();
        LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory((RedisConfiguration)redisConfiguration, (LettuceClientConfiguration)lettuceClientConfiguration);
        lettuceConnectionFactory.afterPropertiesSet();
        return lettuceConnectionFactory;
    }

    @Bean(value={"auth2RedisHashCacheManager"})
    @ConditionalOnMissingBean(name={"auth2RedisHashCacheManager"})
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        LettuceConnectionFactory lettuceConnectionFactory;
        RedisCacheProperties.Cache cache = this.redisCacheProperties.getCache();
        if (this.redisCacheProperties.getUseIocRedisConnectionFactory().booleanValue() && redisConnectionFactory instanceof LettuceConnectionFactory) {
            lettuceConnectionFactory = (LettuceConnectionFactory)redisConnectionFactory;
        } else {
            RedisProperties.Lettuce lettuce = this.redisProperties.getLettuce();
            RedisProperties.Pool lettucePool = lettuce.getPool();
            lettuceConnectionFactory = this.createLettuceConnectionFactory(cache.getDatabaseIndex(), this.redisProperties.getHost(), this.redisProperties.getPort(), this.redisProperties.getPassword(), lettucePool.getMaxIdle(), lettucePool.getMinIdle(), lettucePool.getMaxActive(), lettucePool.getMaxWait().getSeconds(), this.redisProperties.getTimeout().toMillis(), lettuce.getShutdownTimeout());
        }
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig();
        defaultCacheConfig = defaultCacheConfig.entryTtl(cache.getDefaultExpireTime()).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer));
        Set<String> cacheNames = cache.getCacheNames();
        HashMap<String, RedisCacheConfiguration> configMap = new HashMap<String, RedisCacheConfiguration>(cacheNames.size());
        for (String cacheName : cacheNames) {
            configMap.put(cacheName, defaultCacheConfig.entryTtl(cache.getEntryTtl()));
        }
        RedisHashCacheManager cacheManager = RedisHashCacheManager.builder((RedisConnectionFactory)lettuceConnectionFactory).cacheDefaults(defaultCacheConfig).initialCacheNames(cacheNames).withInitialCacheConfigurations(configMap).build();
        return cacheManager;
    }

    @Bean(value={"removeConnectionsByConnectionKeyWithUserIdKeyGenerator"})
    public RemoveConnectionsByConnectionKeyWithUserIdKeyGenerator removeConnectionsByConnectionKeyWithUserIdKeyGenerator() {
        return new RemoveConnectionsByConnectionKeyWithUserIdKeyGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.cache.interceptor.CacheErrorHandler"})
    public CacheErrorHandler cacheErrorHandler() {
        return new CacheErrorHandler(){

            public void handleCacheGetError(@NonNull RuntimeException e, @NonNull Cache cache, @NonNull Object key) {
                log.error("redis\u5f02\u5e38\uff1acacheName=[{}], key=[{}]", new Object[]{cache.getName(), key, e});
            }

            public void handleCachePutError(@NonNull RuntimeException e, @NonNull Cache cache, @NonNull Object key, Object value) {
                log.error("redis\u5f02\u5e38\uff1acacheName=[{}], key=[{}]", new Object[]{cache.getName(), key, e});
            }

            public void handleCacheEvictError(@NonNull RuntimeException e, @NonNull Cache cache, @NonNull Object key) {
                log.error("redis\u5f02\u5e38\uff1acacheName=[{}], key=[{}]", new Object[]{cache.getName(), key, e});
            }

            public void handleCacheClearError(@NonNull RuntimeException e, @NonNull Cache cache) {
                log.error("redis\u5f02\u5e38\uff1acacheName=[{}], ", (Object)cache.getName(), (Object)e);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.cache.annotation.CachingConfigurerSupport"})
    public CachingConfigurerSupport cachingConfigurerSupport(CacheErrorHandler cacheErrorHandler) {
        return new CustomizeCachingConfigurerSupport(cacheErrorHandler);
    }

    private static class CustomizeCachingConfigurerSupport
    extends CachingConfigurerSupport {
        private final CacheErrorHandler cacheErrorHandler;

        public CustomizeCachingConfigurerSupport(CacheErrorHandler cacheErrorHandler) {
            this.cacheErrorHandler = cacheErrorHandler;
        }

        public CacheManager cacheManager() {
            return super.cacheManager();
        }

        public CacheResolver cacheResolver() {
            return super.cacheResolver();
        }

        public KeyGenerator keyGenerator() {
            return super.keyGenerator();
        }

        public CacheErrorHandler errorHandler() {
            return this.cacheErrorHandler;
        }
    }
}

