/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth.cache;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.oauth.justauth.cache.Auth2StateCache;
import top.dcenter.ums.security.core.oauth.justauth.enums.CacheKeyStrategy;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.JustAuthProperties;

public class AuthStateRedisCache
implements Auth2StateCache {
    private final StringRedisTemplate stringRedisTemplate;
    private final Duration timeout;
    private final String cacheKeyPrefix;

    public AuthStateRedisCache(Auth2Properties auth2Properties, Object stringRedisTemplate) {
        this.stringRedisTemplate = (StringRedisTemplate)stringRedisTemplate;
        JustAuthProperties justAuth = auth2Properties.getJustAuth();
        this.timeout = justAuth.getTimeout();
        this.cacheKeyPrefix = justAuth.getCacheKeyPrefix();
    }

    public void cache(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)this.parsingKey(key), (Object)value, this.timeout);
    }

    public void cache(String key, String value, long timeout) {
        this.stringRedisTemplate.opsForValue().set((Object)this.parsingKey(key), (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)this.parsingKey(key));
    }

    public boolean containsKey(String key) {
        return StringUtils.hasText((String)((String)this.stringRedisTemplate.opsForValue().get((Object)this.parsingKey(key))));
    }

    @Override
    public CacheKeyStrategy getCacheKeyStrategy() {
        return CacheKeyStrategy.UUID;
    }

    private String parsingKey(String key) {
        return this.cacheKeyPrefix + key;
    }
}

