/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.tasks.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.dcenter.ums.security.core.executor.config.ExecutorAutoConfiguration;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.tasks.handler.RefreshAccessTokenJobHandler;
import top.dcenter.ums.security.core.tasks.handler.RefreshValidateCodeCacheJobHandler;

@Configuration
@AutoConfigureAfter(value={ExecutorAutoConfiguration.class, Auth2AutoConfiguration.class})
public class TasksAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-refresh-token-job"}, havingValue="true")
    public RefreshAccessTokenJobHandler refreshAccessTokenJobHandler() {
        return new RefreshAccessTokenJobHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.codes", name={"enable-refresh-validate-code-job"}, havingValue="true")
    public RefreshValidateCodeCacheJobHandler refreshValidateCodeJobHandler() {
        return new RefreshValidateCodeCacheJobHandler();
    }
}

