/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);

    public static String getRealIp(HttpServletRequest request) {
        String headerName = "x-forwarded-for";
        String ip = request.getHeader(headerName);
        if (StringUtils.hasText((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip.split(",", 2)[0];
        }
        headerName = "Proxy-Client-IP";
        ip = request.getHeader(headerName);
        if (IpUtil.checkIp(ip)) {
            return ip;
        }
        headerName = "WL-Proxy-Client-IP";
        ip = request.getHeader(headerName);
        if (IpUtil.checkIp(ip)) {
            return ip;
        }
        headerName = "HTTP_CLIENT_IP";
        ip = request.getHeader(headerName);
        if (IpUtil.checkIp(ip)) {
            return ip;
        }
        headerName = "HTTP_X_FORWARDED_FOR";
        ip = request.getHeader(headerName);
        if (IpUtil.checkIp(ip)) {
            return ip;
        }
        headerName = "X-Real-IP";
        ip = request.getHeader(headerName);
        if (IpUtil.checkIp(ip)) {
            return ip;
        }
        headerName = "remote addr";
        ip = request.getRemoteAddr();
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ip = inet.getHostAddress();
            }
            catch (UnknownHostException e) {
                log.debug("\u4ece\u7f51\u5361\u53d6\u672c\u673a\u914d\u7f6e\u7684 IP: {}, headerName: {}, \u9519\u8bef: {}", new Object[]{ip, headerName, e.getMessage()});
            }
        }
        return ip;
    }

    private static boolean checkIp(String ip) {
        return StringUtils.hasText((String)ip) && !"unknown".equalsIgnoreCase(ip);
    }
}

