/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.Serializable;
import java.time.LocalDateTime;

public class ValidateCode
implements Serializable {
    private static final long serialVersionUID = 8564646192066649173L;
    private String code;
    private LocalDateTime expireTime;
    private Integer expireIn;
    private Boolean reuse;

    public ValidateCode() {
        this.code = null;
        this.expireTime = null;
        this.expireIn = null;
        this.reuse = false;
    }

    public ValidateCode(String code, int expireIn) {
        this.code = code;
        this.expireIn = expireIn;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
        this.reuse = false;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss SSS", locale="zh", timezone="GMT+8")
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public void setExpireTime(int expireIn) {
        this.expireIn = expireIn;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
    }

    public ValidateCode(String code, int expireIn, Boolean reuse) {
        this.code = code;
        this.expireIn = expireIn;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
        this.reuse = reuse;
    }

    public boolean isExpired() {
        return LocalDateTime.now().isAfter(this.expireTime);
    }

    public String getCode() {
        return this.code;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public Integer getExpireIn() {
        return this.expireIn;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setExpireIn(Integer expireIn) {
        this.expireIn = expireIn;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public String toString() {
        return "ValidateCode(code=" + this.getCode() + ", expireTime=" + this.getExpireTime() + ", expireIn=" + this.getExpireIn() + ", reuse=" + this.getReuse() + ")";
    }
}

