/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code.enums;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;

public enum ValidateCodeCacheType {
    SESSION{

        @Override
        public boolean save(@NonNull ServletWebRequest request, @NonNull ValidateCode validateCode, @NonNull ValidateCodeType validateCodeType, @Nullable RedisConnectionFactory redisConnectionFactory) {
            HttpServletRequest req = request.getRequest();
            try {
                ValidateCodeCacheType.removeUnnecessaryFieldValue(validateCode);
                req.getSession().setAttribute(validateCodeType.getKeyPrefix(), (Object)validateCode);
            }
            catch (Exception e) {
                String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230 Session \u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), IpUtil.getRealIp((HttpServletRequest)req), validateCode);
                log.error(msg, (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public ValidateCode getCodeInCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @NonNull Class<? extends ValidateCode> clz, @Nullable RedisConnectionFactory redisConnectionFactory) {
            return clz.cast(request.getRequest().getSession().getAttribute(validateCodeType.getKeyPrefix()));
        }

        @Override
        public void removeCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @Nullable RedisConnectionFactory redisConnectionFactory) {
            request.getRequest().getSession().removeAttribute(validateCodeType.getKeyPrefix());
        }
    }
    ,
    REDIS{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean save(@NonNull ServletWebRequest request, @NonNull ValidateCode validateCode, @NonNull ValidateCodeType validateCodeType, @Nullable RedisConnectionFactory redisConnectionFactory) {
            Objects.requireNonNull(redisConnectionFactory, "stringRedisTemplate cannot be null");
            try {
                ValidateCodeCacheType.removeUnnecessaryFieldValue(validateCode);
            }
            catch (IllegalAccessException e) {
                String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230 redis \u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), IpUtil.getRealIp((HttpServletRequest)request.getRequest()), validateCode);
                log.error(msg, (Throwable)e);
                return false;
            }
            byte[] key = (validateCodeType.getKeyPrefix() + request.getSessionId()).getBytes(StandardCharsets.UTF_8);
            byte[] value = JsonUtil.toJsonString((Object)validateCode).getBytes(StandardCharsets.UTF_8);
            try (RedisConnection connection = redisConnectionFactory.getConnection();){
                boolean throwable3 = Optional.ofNullable(connection.setEx(key, (long)(validateCodeType.getExpireIn() - 1), value)).orElse(false);
                return throwable3;
            }
            catch (Exception e) {
                String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230 redis \u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), IpUtil.getRealIp((HttpServletRequest)request.getRequest()), validateCode);
                log.error(msg, (Throwable)e);
                return false;
            }
        }

        @Override
        public ValidateCode getCodeInCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @NonNull Class<? extends ValidateCode> clz, @Nullable RedisConnectionFactory redisConnectionFactory) {
            byte[] jsonBytes;
            Objects.requireNonNull(redisConnectionFactory, "stringRedisTemplate cannot be null");
            byte[] key = (validateCodeType.getKeyPrefix() + request.getSessionId()).getBytes(StandardCharsets.UTF_8);
            try (RedisConnection connection = redisConnectionFactory.getConnection();){
                jsonBytes = connection.get(key);
            }
            catch (Exception e) {
                String msg = String.format("\u4ece redis \u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, sid=%s", e.getMessage(), IpUtil.getRealIp((HttpServletRequest)request.getRequest()), request.getSessionId());
                log.error(msg, (Throwable)e);
                return null;
            }
            if (null == jsonBytes) {
                return null;
            }
            return (ValidateCode)JsonUtil.json2Object((String)new String(jsonBytes, StandardCharsets.UTF_8), clz);
        }

        @Override
        public void removeCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @Nullable RedisConnectionFactory redisConnectionFactory) {
            Objects.requireNonNull(redisConnectionFactory, "stringRedisTemplate cannot be null");
            byte[] key = (validateCodeType.getKeyPrefix() + request.getSessionId()).getBytes(StandardCharsets.UTF_8);
            try (RedisConnection connection = redisConnectionFactory.getConnection();){
                connection.del((byte[][])new byte[][]{key});
            }
            catch (Exception e) {
                String msg = String.format("\u4ece redis \u5220\u9664\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, sid=%s", e.getMessage(), IpUtil.getRealIp((HttpServletRequest)request.getRequest()), request.getSessionId());
                log.error(msg, (Throwable)e);
            }
        }
    };

    private static final Logger log;

    public abstract boolean save(@NonNull ServletWebRequest var1, @NonNull ValidateCode var2, @NonNull ValidateCodeType var3, @Nullable RedisConnectionFactory var4);

    public abstract ValidateCode getCodeInCache(@NonNull ServletWebRequest var1, @NonNull ValidateCodeType var2, @NonNull Class<? extends ValidateCode> var3, @Nullable RedisConnectionFactory var4);

    public abstract void removeCache(@NonNull ServletWebRequest var1, @NonNull ValidateCodeType var2, @Nullable RedisConnectionFactory var3);

    private static void removeUnnecessaryFieldValue(ValidateCode validateCode) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = validateCode.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Transient aTransient = field.getDeclaredAnnotation(Transient.class);
            if (aTransient == null) continue;
            field.set(validateCode, null);
        }
    }

    static {
        log = LoggerFactory.getLogger(ValidateCodeCacheType.class);
    }
}

