/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.config.SecurityRememberMeAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={SecurityRememberMeAutoConfiguration.class, PropertiesAutoConfiguration.class})
public class RememberMeAutoConfigurerAware
implements HttpSecurityAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RememberMeAutoConfigurerAware.class);
    private final ClientProperties clientProperties;
    private final PersistentTokenRepository persistentTokenRepository;
    private final UmsUserDetailsService umsUserDetailsService;
    @Autowired(required=false)
    private RememberMeServices rememberMeServices;

    public RememberMeAutoConfigurerAware(ClientProperties clientProperties, UmsUserDetailsService umsUserDetailsService, @Autowired(required=false) PersistentTokenRepository persistentTokenRepository) {
        this.clientProperties = clientProperties;
        this.persistentTokenRepository = persistentTokenRepository;
        this.umsUserDetailsService = umsUserDetailsService;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) {
    }

    public void preConfigure(HttpSecurity http) throws Exception {
        ClientProperties.RememberMeProperties rememberMe = this.clientProperties.getRememberMe();
        RememberMeConfigurer httpSecurityRememberMeConfigurer = http.rememberMe();
        if (rememberMe.getEnable().booleanValue()) {
            if (this.rememberMeServices != null) {
                httpSecurityRememberMeConfigurer.rememberMeServices(this.rememberMeServices);
                if (this.rememberMeServices instanceof PersistentTokenBasedRememberMeServices) {
                    httpSecurityRememberMeConfigurer.tokenRepository(this.persistentTokenRepository);
                }
            } else {
                httpSecurityRememberMeConfigurer.rememberMeCookieName(rememberMe.getRememberMeCookieName()).tokenRepository(this.persistentTokenRepository);
            }
            httpSecurityRememberMeConfigurer.rememberMeParameter(rememberMe.getRememberMeParameter()).tokenValiditySeconds(Integer.parseInt(String.valueOf(rememberMe.getRememberMeTimeout().getSeconds()))).userDetailsService((UserDetailsService)this.umsUserDetailsService).useSecureCookie(rememberMe.getUseSecureCookie().booleanValue());
        } else {
            httpSecurityRememberMeConfigurer.disable();
        }
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        block78: {
            if (this.persistentTokenRepository != null) {
                JdbcTokenRepositoryImpl jdbcTokenRepository = (JdbcTokenRepositoryImpl)this.persistentTokenRepository;
                DataSource dataSource = jdbcTokenRepository.getDataSource();
                if (dataSource == null) {
                    log.error("\u9519\u8bef: \u4e0d\u80fd\u83b7\u53d6 dataSource \u9519\u8bef");
                    throw new Exception("\u4e0d\u80fd\u83b7\u53d6 dataSource \u9519\u8bef");
                }
                try (Connection connection = dataSource.getConnection();){
                    String database;
                    Throwable throwable;
                    ResultSet resultSet;
                    if (connection == null) {
                        log.error("\u9519\u8bef: \u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                        throw new Exception("\u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                    }
                    try (PreparedStatement preparedStatement = connection.prepareStatement("select database();");){
                        resultSet = preparedStatement.executeQuery();
                        throwable = null;
                        try {
                            resultSet.next();
                            database = resultSet.getString(1);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (resultSet != null) {
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                        }
                    }
                    if (StringUtils.hasText((String)database)) {
                        var7_6 = null;
                        try (Statement statement = connection.createStatement();){
                            resultSet = statement.executeQuery(this.clientProperties.getQueryRememberMeTableExistSql(database));
                            throwable = null;
                            try {
                                resultSet.next();
                                int tableCount = resultSet.getInt(1);
                                if (tableCount >= 1) break block78;
                                try (PreparedStatement preparedStatement = connection.prepareStatement("create table persistent_logins (username varchar(64) not null, series varchar(64) primary key, token varchar(64) not null, last_used timestamp not null)");){
                                    preparedStatement.executeUpdate();
                                    log.info("persistent_logins \u8868\u521b\u5efa\u6210\u529f\uff0cSQL\uff1a{}", (Object)"create table persistent_logins (username varchar(64) not null, series varchar(64) primary key, token varchar(64) not null, last_used timestamp not null)");
                                    if (!connection.getAutoCommit()) {
                                        connection.commit();
                                    }
                                    break block78;
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (resultSet != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        resultSet.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            var7_6 = throwable6;
                            throw throwable6;
                        }
                    }
                    log.error("\u9519\u8bef: \u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                    throw new Exception("\u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                }
            }
        }
    }
}

