/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.ReflectionUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessorHolder;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCode;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.exception.ValidateCodeProcessException;

@Api(tags={"\u9a8c\u8bc1\u7801"})
@ResponseBody
public class ValidateCodeController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeController.class);
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    private ValidateCodeProperties validateCodeProperties;
    @Autowired
    private GenericApplicationContext applicationContext;

    @ApiOperation(value="\u6839\u636e type \u83b7\u53d6\u5bf9\u5e94\u7684\u9a8c\u8bc1\u7801", notes="\u6839\u636e\u4e0d\u540c\u7684\u7c7b\u578b\u54cd\u5e94\u7684\u65b9\u5f0f\u4e0d\u540c, image \u7c7b\u578b\u8fd4\u56de png \u56fe\u7247,sms \u7c7b\u578b\u8fd4\u56de\u5305\u542b\u8fc7\u671f\u65f6\u95f4\u7684 Json \u6570\u636e, \u6ed1\u5757\u9a8c\u8bc1\u7801\u8fd4\u56de Json \u6570\u636e(\u56fe\u7247\u5df2\u8f6c\u6362\u6210BASE64\u7f16\u7801\u7684\u5b57\u7b26\u4e32)", httpMethod="GET")
    @RequestMapping(value={"/code/{type}"}, method={RequestMethod.GET})
    public void createCode(@ApiParam(name="type", value="\u9a8c\u8bc1\u7801\u7c7b\u578b, \u76ee\u524d\u652f\u6301: image, sms, slider", allowableValues="image, sms, track, slider, selection, customize", required=true, example="image") @PathVariable(value="type") String type, HttpServletRequest request, HttpServletResponse response) {
        ValidateCodeProcessor validateCodeProcessor = this.validateCodeProcessorHolder != null ? this.validateCodeProcessorHolder.findValidateCodeProcessor(type) : null;
        if (validateCodeProcessor == null) {
            String ip = IpUtil.getRealIp((HttpServletRequest)request);
            log.warn("\u521b\u5efa\u9a8c\u8bc1\u7801\u9519\u8bef: error={}, ip={}, type={}", new Object[]{ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE.getMsg(), ip, type});
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, ip, type);
        }
        boolean validateStatus = validateCodeProcessor.produce(new ServletWebRequest(request, response));
        if (!validateStatus) {
            String ip = IpUtil.getRealIp((HttpServletRequest)request);
            log.warn("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: error={}, ip={}, type={}", new Object[]{ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE.getMsg(), ip, type});
            throw new ValidateCodeProcessException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, ip, type);
        }
    }

    @ApiOperation(value="\u6821\u9a8c\u6ed1\u5757\u9a8c\u8bc1\u7801", notes="\u6240\u6709\u9a8c\u8bc1\u903b\u8f91\u90fd\u901a\u8fc7, \u8fd4\u56de\u6210\u529f\u7684 Json \u8be6\u7ec6, ", httpMethod="POST", response=ResponseResult.class)
    @RequestMapping(value={"/slider/check"}, method={RequestMethod.POST})
    public ResponseResult sliderCheck(HttpServletRequest request) {
        SliderCode sliderCode = (SliderCode)request.getSession().getAttribute(ValidateCodeType.SLIDER.getKeyPrefix());
        return ResponseResult.success(null, (Object)sliderCode.getCode());
    }

    public void afterPropertiesSet() throws Exception {
        this.validateCodeProcessorHolder = (ValidateCodeProcessorHolder)this.applicationContext.getBean(ValidateCodeProcessorHolder.class);
        String methodName = "sliderCheck";
        ReflectionUtil.setRequestMappingUri((String)methodName, (String)this.validateCodeProperties.getSlider().getSliderCheckUrl(), this.getClass(), (Class[])new Class[]{HttpServletRequest.class});
        methodName = "createCode";
        ReflectionUtil.setRequestMappingUri((String)methodName, (String)(this.validateCodeProperties.getValidateCodeUrlPrefix() + "/" + "{type}"), this.getClass(), (Class[])new Class[]{String.class, HttpServletRequest.class, HttpServletResponse.class});
        ReflectionUtil.registerController((String)"validateCodeController", (GenericApplicationContext)this.applicationContext, null);
    }
}

