/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.handler;

import java.io.IOException;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.util.RequestUtil;
import top.dcenter.ums.security.core.vo.UserInfoJsonVo;
import top.dcenter.ums.security.jwt.JwtContext;

public class ClientAuthenticationSuccessHandler
extends BaseAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthenticationSuccessHandler.class);
    protected final RequestCache requestCache;
    protected final String auth2RedirectUrl;
    protected final LoginProcessType loginProcessType;

    public ClientAuthenticationSuccessHandler(ClientProperties clientProperties, String auth2RedirectUrl) {
        this.auth2RedirectUrl = auth2RedirectUrl;
        this.requestCache = new HttpSessionRequestCache();
        this.loginProcessType = clientProperties.getLoginProcessType();
        this.setTargetUrlParameter(clientProperties.getTargetUrlParameter());
        this.setUseReferer(clientProperties.getUseReferer());
        this.setAlwaysUseDefaultTargetUrl(clientProperties.getAlwaysUseDefaultTargetUrl());
        this.ignoreUrls = new HashSet();
        this.ignoreUrls.add(clientProperties.getLoginPage());
        this.ignoreUrls.add(clientProperties.getLogoutUrl());
        super.setDefaultTargetUrl(clientProperties.getSuccessUrl());
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String username = authentication.getName();
        String ip = IpUtil.getRealIp((HttpServletRequest)request);
        String userAgent = request.getHeader("User-Agent");
        String sid = request.getSession(true).getId();
        log.info("\u767b\u5f55\u6210\u529f: user={}, ip={}, ua={}, sid={}", new Object[]{username, ip, userAgent, sid});
        AbstractAuthenticationToken token = (AbstractAuthenticationToken)authentication;
        try {
            UserInfoJsonVo userInfoJsonVo = new UserInfoJsonVo(username, username, null, null, null, token.getAuthorities());
            String jwtStringIfAllowBodyParameter = JwtContext.getJwtStringIfAllowBodyParameter((Authentication)authentication);
            if (StringUtils.hasText((String)jwtStringIfAllowBodyParameter)) {
                userInfoJsonVo.setJwt(jwtStringIfAllowBodyParameter);
            }
            if (JwtContext.isRefreshJwtByRefreshToken().booleanValue()) {
                userInfoJsonVo.setRefreshToken(JwtContext.getJwtRefreshToken());
            }
            String targetUrl = this.determineTargetUrl(request, response);
            userInfoJsonVo.setTargetUrl(this.getJsonTargetUrl(targetUrl, request));
            if (LoginProcessType.JSON.equals((Object)this.loginProcessType)) {
                this.clearAuthenticationAttributes(request);
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.OK.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.success(null, (Object)userInfoJsonVo)));
                return;
            }
            if (JsonUtil.isAjaxOrJson((HttpServletRequest)request)) {
                this.clearAuthenticationAttributes(request);
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.OK.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.success(null, (Object)userInfoJsonVo)));
                return;
            }
            this.clearAuthenticationAttributes(request);
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
        }
        catch (Exception e) {
            log.error(String.format("\u8bbe\u7f6e\u767b\u5f55\u6210\u529f\u540e\u8df3\u8f6c\u7684URL\u5931\u8d25: error=%s, user=%s, ip=%s, ua=%s, sid=%s", e.getMessage(), username, ip, userAgent, sid), (Throwable)e);
            super.onAuthenticationSuccess(request, response, authentication);
        }
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String referer;
        String defaultTargetUrl = this.getDefaultTargetUrl();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (this.isAlwaysUseDefaultTargetUrl() || request.getServletPath().startsWith(this.auth2RedirectUrl)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Using default url %s", (Object)defaultTargetUrl));
            }
            this.requestCache.removeRequest(request, response);
            return defaultTargetUrl;
        }
        if (savedRequest != null) {
            String redirectUrl = savedRequest.getRedirectUrl();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"using url %s from default saved request %s", (Object)redirectUrl));
            }
            return redirectUrl;
        }
        String targetUrl = null;
        String targetUrlParameter = this.getTargetUrlParameter();
        if (targetUrlParameter != null) {
            targetUrl = request.getParameter(targetUrlParameter);
            if (StringUtils.hasText((String)targetUrl) && MvcUtil.isSelfTopDomain(targetUrl)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)LogMessage.format((String)"Using url %s from request parameter %s", (Object)targetUrl, (Object)targetUrlParameter));
                }
                return targetUrl;
            }
            targetUrl = null;
        }
        if (this.useReferer && StringUtils.hasText((String)(referer = request.getHeader("Referer"))) && MvcUtil.isSelfTopDomain(referer)) {
            targetUrl = referer;
        }
        if (!StringUtils.hasText((String)targetUrl) || this.isIgnoreUrl(targetUrl)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Using default url %s", (Object)defaultTargetUrl));
            }
            return defaultTargetUrl;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)LogMessage.format((String)"Using url %s from Referer header", (Object)targetUrl));
        }
        return targetUrl;
    }

    public void setUseReferer(boolean useReferer) {
        super.setUseReferer(useReferer);
        this.useReferer = useReferer;
    }

    private String getJsonTargetUrl(String targetUrl, HttpServletRequest request) {
        if (!UrlUtils.isAbsoluteUrl((String)targetUrl)) {
            targetUrl = request.getContextPath() + targetUrl;
        }
        return targetUrl;
    }

    private boolean isIgnoreUrl(String targetUrl) {
        String url = RequestUtil.getRequestUri(targetUrl);
        return this.ignoreUrls.stream().anyMatch(url::startsWith);
    }
}

