/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.properties;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeCacheType;

@ConfigurationProperties(value="ums.codes")
public class ValidateCodeProperties {
    private final ImageCodeProperties image = new ImageCodeProperties();
    private final SmsCodeProperties sms = new SmsCodeProperties();
    private final SliderCodeProperties slider = new SliderCodeProperties();
    private final TrackCodeProperties track = new TrackCodeProperties();
    private final SelectionCodeProperties selection = new SelectionCodeProperties();
    private final CustomizeCodeProperties customize = new CustomizeCodeProperties();
    private String validateCodeUrlPrefix = "/code";
    private ValidateCodeCacheType validateCodeCacheType = ValidateCodeCacheType.SESSION;
    private String refreshValidateCodeJobCron = "0 * 4 * * ?";
    private Boolean enableRefreshValidateCodeJob = false;
    private Integer totalImages = 100;

    public ImageCodeProperties getImage() {
        return this.image;
    }

    public SmsCodeProperties getSms() {
        return this.sms;
    }

    public SliderCodeProperties getSlider() {
        return this.slider;
    }

    public TrackCodeProperties getTrack() {
        return this.track;
    }

    public SelectionCodeProperties getSelection() {
        return this.selection;
    }

    public CustomizeCodeProperties getCustomize() {
        return this.customize;
    }

    public String getValidateCodeUrlPrefix() {
        return this.validateCodeUrlPrefix;
    }

    public ValidateCodeCacheType getValidateCodeCacheType() {
        return this.validateCodeCacheType;
    }

    public String getRefreshValidateCodeJobCron() {
        return this.refreshValidateCodeJobCron;
    }

    public Boolean getEnableRefreshValidateCodeJob() {
        return this.enableRefreshValidateCodeJob;
    }

    public Integer getTotalImages() {
        return this.totalImages;
    }

    public void setValidateCodeUrlPrefix(String validateCodeUrlPrefix) {
        this.validateCodeUrlPrefix = validateCodeUrlPrefix;
    }

    public void setValidateCodeCacheType(ValidateCodeCacheType validateCodeCacheType) {
        this.validateCodeCacheType = validateCodeCacheType;
    }

    public void setRefreshValidateCodeJobCron(String refreshValidateCodeJobCron) {
        this.refreshValidateCodeJobCron = refreshValidateCodeJobCron;
    }

    public void setEnableRefreshValidateCodeJob(Boolean enableRefreshValidateCodeJob) {
        this.enableRefreshValidateCodeJob = enableRefreshValidateCodeJob;
    }

    public void setTotalImages(Integer totalImages) {
        this.totalImages = totalImages;
    }

    public static class CustomizeCodeProperties {
        private List<String> authUrls = new ArrayList<String>();
        private String requestParamName = "customizeCode";
        private Integer expire = 180;

        public List<String> getAuthUrls() {
            return this.authUrls;
        }

        public String getRequestParamName() {
            return this.requestParamName;
        }

        public Integer getExpire() {
            return this.expire;
        }

        public void setAuthUrls(List<String> authUrls) {
            this.authUrls = authUrls;
        }

        public void setRequestParamName(String requestParamName) {
            this.requestParamName = requestParamName;
        }

        public void setExpire(Integer expire) {
            this.expire = expire;
        }
    }

    public static class SelectionCodeProperties {
        private List<String> authUrls = new ArrayList<String>();
        private String requestParamName = "selectionCode";
        private Integer expire = 180;

        public List<String> getAuthUrls() {
            return this.authUrls;
        }

        public String getRequestParamName() {
            return this.requestParamName;
        }

        public Integer getExpire() {
            return this.expire;
        }

        public void setAuthUrls(List<String> authUrls) {
            this.authUrls = authUrls;
        }

        public void setRequestParamName(String requestParamName) {
            this.requestParamName = requestParamName;
        }

        public void setExpire(Integer expire) {
            this.expire = expire;
        }
    }

    public static class TrackCodeProperties {
        private List<String> authUrls = new ArrayList<String>();
        private String requestParamName = "trackCode";
        private Integer expire = 180;

        public List<String> getAuthUrls() {
            return this.authUrls;
        }

        public String getRequestParamName() {
            return this.requestParamName;
        }

        public Integer getExpire() {
            return this.expire;
        }

        public void setAuthUrls(List<String> authUrls) {
            this.authUrls = authUrls;
        }

        public void setRequestParamName(String requestParamName) {
            this.requestParamName = requestParamName;
        }

        public void setExpire(Integer expire) {
            this.expire = expire;
        }
    }

    public static class SliderCodeProperties {
        private List<String> authUrls = new ArrayList<String>();
        private String sliderCheckUrl = "/slider/check";
        private String requestParamName = "sliderCode";
        public String tokenRequestParamName = "sliderToken";
        public String xRequestParamName = "x";
        public String yRequestParamName = "y";
        private Integer expire = 180;
        private Integer grayscale = 5;
        private String imageSuffix = "png";
        private String originalImageDirectory = "classpath:static/image/slider/original";
        private String templateImageDirectory = "classpath:static/image/slider/template";
        private String codeImageDirectory = "classpath:static/image/slider/code";

        public List<String> getAuthUrls() {
            return this.authUrls;
        }

        public String getSliderCheckUrl() {
            return this.sliderCheckUrl;
        }

        public String getRequestParamName() {
            return this.requestParamName;
        }

        public String getTokenRequestParamName() {
            return this.tokenRequestParamName;
        }

        public String getXRequestParamName() {
            return this.xRequestParamName;
        }

        public String getYRequestParamName() {
            return this.yRequestParamName;
        }

        public Integer getExpire() {
            return this.expire;
        }

        public Integer getGrayscale() {
            return this.grayscale;
        }

        public String getImageSuffix() {
            return this.imageSuffix;
        }

        public String getOriginalImageDirectory() {
            return this.originalImageDirectory;
        }

        public String getTemplateImageDirectory() {
            return this.templateImageDirectory;
        }

        public String getCodeImageDirectory() {
            return this.codeImageDirectory;
        }

        public void setAuthUrls(List<String> authUrls) {
            this.authUrls = authUrls;
        }

        public void setSliderCheckUrl(String sliderCheckUrl) {
            this.sliderCheckUrl = sliderCheckUrl;
        }

        public void setRequestParamName(String requestParamName) {
            this.requestParamName = requestParamName;
        }

        public void setTokenRequestParamName(String tokenRequestParamName) {
            this.tokenRequestParamName = tokenRequestParamName;
        }

        public void setXRequestParamName(String xRequestParamName) {
            this.xRequestParamName = xRequestParamName;
        }

        public void setYRequestParamName(String yRequestParamName) {
            this.yRequestParamName = yRequestParamName;
        }

        public void setExpire(Integer expire) {
            this.expire = expire;
        }

        public void setGrayscale(Integer grayscale) {
            this.grayscale = grayscale;
        }

        public void setImageSuffix(String imageSuffix) {
            this.imageSuffix = imageSuffix;
        }

        public void setOriginalImageDirectory(String originalImageDirectory) {
            this.originalImageDirectory = originalImageDirectory;
        }

        public void setTemplateImageDirectory(String templateImageDirectory) {
            this.templateImageDirectory = templateImageDirectory;
        }

        public void setCodeImageDirectory(String codeImageDirectory) {
            this.codeImageDirectory = codeImageDirectory;
        }
    }

    public static class ImageCodeProperties {
        private Integer width = 270;
        private Integer height = 60;
        private Integer length = 4;
        private Integer expire = 300;
        private String requestParamImageCodeName = "imageCode";
        private String imageCacheDirectory = "classpath:static/image/code";
        private List<String> authUrls;

        public ImageCodeProperties() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("/authentication/form");
            this.authUrls = list;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Integer getLength() {
            return this.length;
        }

        public Integer getExpire() {
            return this.expire;
        }

        public String getRequestParamImageCodeName() {
            return this.requestParamImageCodeName;
        }

        public String getImageCacheDirectory() {
            return this.imageCacheDirectory;
        }

        public List<String> getAuthUrls() {
            return this.authUrls;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public void setLength(Integer length) {
            this.length = length;
        }

        public void setExpire(Integer expire) {
            this.expire = expire;
        }

        public void setRequestParamImageCodeName(String requestParamImageCodeName) {
            this.requestParamImageCodeName = requestParamImageCodeName;
        }

        public void setImageCacheDirectory(String imageCacheDirectory) {
            this.imageCacheDirectory = imageCacheDirectory;
        }

        public void setAuthUrls(List<String> authUrls) {
            this.authUrls = authUrls;
        }
    }

    public static class SmsCodeProperties {
        private Integer length = 6;
        private Integer expire = 120;
        private String requestParamSmsCodeName = "smsCode";
        private String requestParamMobileName = "mobile";
        private List<String> authUrls = new ArrayList<String>();

        public Integer getLength() {
            return this.length;
        }

        public Integer getExpire() {
            return this.expire;
        }

        public String getRequestParamSmsCodeName() {
            return this.requestParamSmsCodeName;
        }

        public String getRequestParamMobileName() {
            return this.requestParamMobileName;
        }

        public List<String> getAuthUrls() {
            return this.authUrls;
        }

        public void setLength(Integer length) {
            this.length = length;
        }

        public void setExpire(Integer expire) {
            this.expire = expire;
        }

        public void setRequestParamSmsCodeName(String requestParamSmsCodeName) {
            this.requestParamSmsCodeName = requestParamSmsCodeName;
        }

        public void setRequestParamMobileName(String requestParamMobileName) {
            this.requestParamMobileName = requestParamMobileName;
        }

        public void setAuthUrls(List<String> authUrls) {
            this.authUrls = authUrls;
        }
    }
}

