/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.UrlUtil;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessorHolder;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.ConvertUtil;

public class ValidateCodeFilter
extends OncePerRequestFilter
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeFilter.class);
    private final ValidateCodeProperties validateCodeProperties;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final AntPathMatcher pathMatcher;
    private final ValidateCodeProcessorHolder validateCodeProcessorHolder;
    private final Map<String, ValidateCodeType> authUrlMap = new HashMap<String, ValidateCodeType>();

    public ValidateCodeFilter(ValidateCodeProcessorHolder validateCodeProcessorHolder, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, ValidateCodeProperties validateCodeProperties) {
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.pathMatcher = new AntPathMatcher();
        this.validateCodeProcessorHolder = validateCodeProcessorHolder;
        this.validateCodeProperties = validateCodeProperties;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        ConvertUtil.list2Map(this.validateCodeProperties.getImage().getAuthUrls(), ValidateCodeType.IMAGE, this.authUrlMap);
        ConvertUtil.list2Map(this.validateCodeProperties.getSlider().getAuthUrls(), ValidateCodeType.SLIDER, this.authUrlMap);
        this.authUrlMap.put(this.validateCodeProperties.getSlider().getSliderCheckUrl(), ValidateCodeType.SLIDER);
        ConvertUtil.list2Map(this.validateCodeProperties.getTrack().getAuthUrls(), ValidateCodeType.TRACK, this.authUrlMap);
        ConvertUtil.list2Map(this.validateCodeProperties.getSelection().getAuthUrls(), ValidateCodeType.SELECTION, this.authUrlMap);
        ConvertUtil.list2Map(this.validateCodeProperties.getCustomize().getAuthUrls(), ValidateCodeType.CUSTOMIZE, this.authUrlMap);
        ConvertUtil.list2Map(this.validateCodeProperties.getSms().getAuthUrls(), ValidateCodeType.SMS, this.authUrlMap);
    }

    protected void doFilterInternal(HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        block3: {
            String requestUri = request.getRequestURI();
            ValidateCodeType validateCodeType = this.getValidateCodeType(request);
            try {
                if (validateCodeType == null) break block3;
                String typeName = validateCodeType.name();
                ValidateCodeProcessor validateCodeProcessor = this.validateCodeProcessorHolder.findValidateCodeProcessor(validateCodeType);
                if (validateCodeProcessor != null) {
                    validateCodeProcessor.validate(new ServletWebRequest(request, response));
                    break block3;
                }
                String ip = IpUtil.getRealIp((HttpServletRequest)request);
                log.warn("\u8fdd\u6cd5\u7684\u9a8c\u8bc1\u7801\u7c7b\u578b: error={}, ip={}, sid={}, type={}", new Object[]{ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE.getMsg(), ip, request.getSession(true).getId(), typeName});
                throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, ip, typeName);
            }
            catch (Exception e) {
                String ip = IpUtil.getRealIp((HttpServletRequest)request);
                log.warn("\u9a8c\u8bc1\u7801\u9519\u8bef: error={}, ip={}, sid={}, uri={}", new Object[]{e.getMessage(), ip, request.getSession(true).getId(), requestUri});
                Object ex = e instanceof AbstractResponseJsonAuthenticationException ? (AbstractResponseJsonAuthenticationException)e : new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_ERROR, e, ip, validateCodeType.name());
                this.baseAuthenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)((Object)ex));
                return;
            }
        }
        this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
    }

    private ValidateCodeType getValidateCodeType(HttpServletRequest request) {
        String method = request.getMethod();
        if (!"GET".equalsIgnoreCase(method)) {
            String requestUri = UrlUtil.getUrlPathHelper().getPathWithinApplication(request);
            ValidateCodeType result = this.authUrlMap.getOrDefault(requestUri, null);
            if (result != null) {
                return result;
            }
            for (Map.Entry<String, ValidateCodeType> entry : this.authUrlMap.entrySet()) {
                if (!this.pathMatcher.match(entry.getKey(), requestUri)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public Map<String, ValidateCodeType> getAuthUrlMap() {
        return this.authUrlMap;
    }
}

