/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.slider;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.validate.code.slider.SliderCodeFactory;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCode;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCodeUtil;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class SimpleSliderCodeFactory
implements SliderCodeFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleSliderCodeFactory.class);
    public static final String IMAGE_NAME_DELIMITER = "_";
    public static final Integer IMAGE_NAME_SPLIT_LIMIT = 5;
    public static final String SRC_SUFFIX = ".temp";
    public static final String MARK_SUFFIX = ".mark";
    private static final float PERCENTAGE = 0.9f;
    private final ValidateCodeProperties validateCodeProperties;
    private final String[] templateImagePaths;
    private final String[] originalImagePaths;
    private volatile String[] codeImagePaths = null;
    private final Integer totalImages;
    private final Integer expireIn;
    private final Integer grayscale;

    public SimpleSliderCodeFactory(ValidateCodeProperties validateCodeProperties) {
        this.validateCodeProperties = validateCodeProperties;
        ValidateCodeProperties.SliderCodeProperties slider = validateCodeProperties.getSlider();
        this.grayscale = slider.getGrayscale();
        this.totalImages = validateCodeProperties.getTotalImages();
        this.expireIn = slider.getExpire();
        if (slider.getAuthUrls().size() > 0) {
            this.templateImagePaths = this.getImagesAbsPaths(slider.getTemplateImageDirectory(), slider.getImageSuffix());
            this.originalImagePaths = this.getImagesAbsPaths(slider.getOriginalImageDirectory(), slider.getImageSuffix());
        } else {
            this.templateImagePaths = null;
            this.originalImagePaths = null;
        }
    }

    @PostConstruct
    public void init() {
        if (this.validateCodeProperties.getSlider().getAuthUrls().size() > 0) {
            this.readOrCreateCacheImageCodes();
        }
    }

    @Override
    public SliderCode getSliderCode() {
        try {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (this.codeImagePaths != null) {
                String srcImageAbsPath = this.codeImagePaths[random.nextInt(this.totalImages)];
                String markImageAbsPath = this.getMarkImageAbsPath(srcImageAbsPath);
                byte[] srcImageBytes = Files.readAllBytes(Paths.get(srcImageAbsPath, new String[0]));
                byte[] markImageBytes = Files.readAllBytes(Paths.get(markImageAbsPath, new String[0]));
                String srcImageFileName = ValidateCodeUtil.getFileName(srcImageAbsPath);
                if (!StringUtils.hasText((String)srcImageFileName)) {
                    throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, null, null);
                }
                return this.getSliderCode(srcImageBytes, markImageBytes, srcImageFileName);
            }
            ImageInfo imageInfo = this.generateSliderImage(random, "");
            byte[] srcImageBytes = SliderCodeUtil.getImageByteBASE64(imageInfo.sliderCodeInfo.srcImage);
            byte[] markImageBytes = SliderCodeUtil.getImageByteBASE64(imageInfo.sliderCodeInfo.markImage);
            return this.getSliderCode(srcImageBytes, markImageBytes, imageInfo.srcImageAbsPath.substring("/".length()));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9a8c\u8bc1\u7801\u9519\u8bef: " + e.getMessage(), (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, null, null);
        }
    }

    @NonNull
    private SliderCode getSliderCode(byte[] srcImageBytes, byte[] markImageBytes, String srcImageFileName) {
        String[] split = srcImageFileName.split(IMAGE_NAME_DELIMITER, IMAGE_NAME_SPLIT_LIMIT);
        if (split.length != IMAGE_NAME_SPLIT_LIMIT) {
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, null, null);
        }
        String token = split[4];
        token = token.substring(0, token.lastIndexOf("."));
        int locationX = Integer.parseInt(split[0]);
        int locationY = Integer.parseInt(split[1]);
        int width = Integer.parseInt(split[2]);
        int height = Integer.parseInt(split[3]);
        return new SliderCode(null, this.expireIn, token, new String(markImageBytes, StandardCharsets.UTF_8), new String(srcImageBytes, StandardCharsets.UTF_8), locationX, locationY, width, height);
    }

    @Override
    public void refreshValidateCodeJob() {
        if (this.validateCodeProperties.getSlider().getAuthUrls().size() < 1) {
            return;
        }
        Instant now = Instant.now();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String[] oldCodeImagePaths = this.codeImagePaths;
        String[] newImageCodePaths = new String[this.totalImages.intValue()];
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        String codeImageAbsPath = ValidateCodeUtil.getAbsPath(slider.getCodeImageDirectory());
        CopyOnWriteArrayList failures = new CopyOnWriteArrayList();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int y = 0; y < this.totalImages; ++y) {
            try {
                ImageInfo imageInfo = this.generateSliderImage(random, codeImageAbsPath);
                newImageCodePaths[y] = imageInfo.srcImageAbsPath;
                int index = y;
                CompletableFuture<Void> voidCompletableFuture = CompletableFuture.runAsync(() -> {
                    try {
                        this.write2File(imageInfo.srcImageAbsPath, imageInfo.sliderCodeInfo.srcImage);
                        this.write2File(imageInfo.markImageAbsPath, imageInfo.sliderCodeInfo.markImage);
                    }
                    catch (Exception e) {
                        failures.add(index);
                    }
                });
                futures.add(voidCompletableFuture);
                continue;
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u65b0\u6ed1\u5757\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                ThreadLocalRandom localRandom = ThreadLocalRandom.current();
                for (Integer index : failures) {
                    try {
                        ImageInfo imageInfo = this.generateSliderImage(localRandom, codeImageAbsPath);
                        newImageCodePaths[index.intValue()] = imageInfo.srcImageAbsPath;
                        this.write2File(imageInfo.srcImageAbsPath, imageInfo.sliderCodeInfo.srcImage);
                        this.write2File(imageInfo.markImageAbsPath, imageInfo.sliderCodeInfo.markImage);
                    }
                    catch (Exception e) {
                        newImageCodePaths[index.intValue()] = ValidateCodeUtil.getImageAbsPath(newImageCodePaths);
                    }
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u521b\u5efa\u65b0\u6ed1\u5757\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        this.codeImagePaths = newImageCodePaths;
        if (oldCodeImagePaths != null) {
            for (int i = 0; i < this.totalImages; ++i) {
                String srcImageCodePath = oldCodeImagePaths[i];
                try {
                    String markImageCodePath;
                    boolean deleteIfExists = Files.deleteIfExists(Paths.get(srcImageCodePath, new String[0]));
                    if (!deleteIfExists) {
                        log.warn("\u5220\u9664\u65e7\u7684\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: {}", (Object)srcImageCodePath);
                    }
                    if (deleteIfExists = Files.deleteIfExists(Paths.get(markImageCodePath = this.getMarkImageAbsPath(srcImageCodePath), new String[0]))) continue;
                    log.warn("\u5220\u9664\u65e7\u7684\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: {}", (Object)markImageCodePath);
                    continue;
                }
                catch (Exception e) {
                    log.warn("\u5220\u9664\u65e7\u7684\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: " + srcImageCodePath, (Throwable)e);
                }
            }
            oldCodeImagePaths = null;
        }
        log.info("\u751f\u6210\u56fe\u7247\u9a8c\u8bc1\u7801\u4efb\u52a1\u603b\u8017\u65f6={} \u6beb\u79d2", (Object)(Instant.now().toEpochMilli() - now.toEpochMilli()));
    }

    private void readOrCreateCacheImageCodes() {
        Instant now = Instant.now();
        String[] newTempImagePaths = new String[this.totalImages.intValue()];
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        String codeImageAbsPath = ValidateCodeUtil.getAbsPath(slider.getCodeImageDirectory());
        File fileDirs = Paths.get(codeImageAbsPath, new String[0]).toFile();
        if (fileDirs.isDirectory() && fileDirs.canRead()) {
            List<File> fileList = Arrays.stream((Object[])Optional.ofNullable(fileDirs.listFiles()).orElse(new File[0])).filter(File::isFile).filter(f -> f.getName().endsWith(SRC_SUFFIX)).collect(Collectors.toList());
            int size = fileList.size();
            if (size >= (int)((float)this.totalImages.intValue() * 0.9f)) {
                ValidateCodeUtil.readFiles2CacheImageCodes(newTempImagePaths, fileList);
                this.codeImagePaths = newTempImagePaths;
            } else {
                fileList.forEach(f -> {
                    try {
                        Path srcFilePath = f.toPath();
                        Files.delete(srcFilePath);
                        String fileAbsolutePath = f.getAbsolutePath();
                        String markAbsPath = this.getMarkImageAbsPath(fileAbsolutePath);
                        Files.delete(Paths.get(markAbsPath, new String[0]));
                    }
                    catch (IOException e) {
                        String msg = String.format("\u5220\u9664\u7f13\u5b58\u7684\u6ed1\u5757\u9a8c\u8bc1\u7801 %s \u9519\u8bef: %s", f.getPath(), e.getMessage());
                        log.error(msg, (Throwable)e);
                    }
                });
                this.refreshValidateCodeJob();
            }
        }
        log.info("\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u6216\u521b\u5efa\u6ed1\u5757\u9a8c\u8bc1\u7801\u603b\u8017\u65f6: {} \u6beb\u79d2", (Object)(Instant.now().toEpochMilli() - now.toEpochMilli()));
    }

    @NonNull
    private String getMarkImageAbsPath(@NonNull String srcImageAbsPath) {
        return srcImageAbsPath.substring(0, srcImageAbsPath.length() - SRC_SUFFIX.length()).concat(MARK_SUFFIX);
    }

    private String[] getImagesAbsPaths(String imageDirectory, String imageSuffix) {
        List<String> filePathList;
        String originalAbsPath = ValidateCodeUtil.getAbsPath(imageDirectory);
        File file = Paths.get(originalAbsPath, new String[0]).toFile();
        if (file.exists() && (filePathList = Arrays.stream((Object[])Optional.ofNullable(file.listFiles()).orElse(new File[0])).filter(File::isFile).map(File::getAbsolutePath).filter(path -> path.endsWith(imageSuffix)).collect(Collectors.toList())).size() > 0) {
            return filePathList.toArray(new String[0]);
        }
        throw new RuntimeException(String.format("\u5728\u76ee\u5f55 %s \u4e2d\u6ca1\u6709\u6ed1\u5757\u9a8c\u8bc1\u7801\u56fe\u7247(%s), \u8bf7\u786e\u4fdd\u81f3\u5c11\u4e00\u5f20\u56fe\u7247", imageDirectory, imageSuffix));
    }

    private void write2File(String absPath, BufferedImage image) throws IOException {
        Files.write(Paths.get(absPath, new String[0]), SliderCodeUtil.getImageByteBASE64(image), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    private ImageInfo generateSliderImage(ThreadLocalRandom random, String codeImageAbsPath) throws IOException {
        File templateImage = SliderCodeUtil.getRandomImageFile(this.templateImagePaths, random);
        File originalImage = SliderCodeUtil.getRandomImageFile(this.originalImagePaths, random);
        SliderCodeInfo sliderCodeInfo = this.createSliderCodeInfo(templateImage, originalImage, this.grayscale);
        String fileName = sliderCodeInfo.fileName.toString();
        String srcImageFileName = fileName + SRC_SUFFIX;
        String markImageFileName = fileName + MARK_SUFFIX;
        String srcImageAbsPath = codeImageAbsPath + "/" + srcImageFileName;
        String markImageAbsPath = codeImageAbsPath + "/" + markImageFileName;
        return new ImageInfo(srcImageAbsPath, markImageAbsPath, sliderCodeInfo);
    }

    private SliderCodeInfo createSliderCodeInfo(File templateFile, File originalFile, int grayscale) throws IOException {
        BufferedImage templateImage = ImageIO.read(templateFile);
        BufferedImage oriImage = ImageIO.read(originalFile);
        Map<String, Object> sliderCodeInfoMap = SliderCodeUtil.cutImageByTemplate(templateImage, oriImage, grayscale);
        BufferedImage markImage = (BufferedImage)sliderCodeInfoMap.get("markImage");
        BufferedImage srcImage = (BufferedImage)sliderCodeInfoMap.get("srcImage");
        StringBuilder fileName = new StringBuilder();
        fileName.append(sliderCodeInfoMap.get("locationX")).append(IMAGE_NAME_DELIMITER).append(sliderCodeInfoMap.get("locationY")).append(IMAGE_NAME_DELIMITER).append(srcImage.getWidth()).append(IMAGE_NAME_DELIMITER).append(srcImage.getHeight()).append(IMAGE_NAME_DELIMITER).append(ValidateCodeUtil.getUuid());
        return new SliderCodeInfo(srcImage, markImage, fileName);
    }

    private static class ImageInfo {
        private final String srcImageAbsPath;
        private final String markImageAbsPath;
        private final SliderCodeInfo sliderCodeInfo;

        ImageInfo(String srcImageAbsPath, String markImageAbsPath, SliderCodeInfo sliderCodeInfo) {
            this.srcImageAbsPath = srcImageAbsPath;
            this.markImageAbsPath = markImageAbsPath;
            this.sliderCodeInfo = sliderCodeInfo;
        }
    }

    private static class SliderCodeInfo {
        private final BufferedImage srcImage;
        private final BufferedImage markImage;
        private final StringBuilder fileName;

        public SliderCodeInfo(BufferedImage srcImage, BufferedImage markImage, StringBuilder fileName) {
            this.srcImage = srcImage;
            this.markImage = markImage;
            this.fileName = fileName;
        }
    }
}

