/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.sms;

import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeCacheType;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.api.validate.code.sms.SmsCodeSender;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.exception.SmsCodeRepeatedRequestException;
import top.dcenter.ums.security.core.exception.ValidateCodeParamErrorException;

public class SmsValidateCodeProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SmsValidateCodeProcessor.class);
    @Autowired
    protected SmsCodeSender smsCodeSender;
    @Autowired
    protected ValidateCodeProperties validateCodeProperties;

    public SmsValidateCodeProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeCacheType validateCodeCacheType, @Nullable RedisConnectionFactory redisConnectionFactory) {
        super(validateCodeGeneratorHolder, validateCodeCacheType, ValidateCode.class, redisConnectionFactory);
    }

    @Override
    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        String mobile = null;
        HttpServletRequest req = request.getRequest();
        String ip = IpUtil.getRealIp((HttpServletRequest)req);
        String sid = request.getSessionId();
        String uri = req.getRequestURI();
        try {
            mobile = ServletRequestUtils.getRequiredStringParameter((ServletRequest)req, (String)this.validateCodeProperties.getSms().getRequestParamMobileName());
            if (StringUtils.hasText((String)mobile) && mobile.matches("^[1]([3-9])[0-9]{9}$")) {
                ValidateCode codeInCache = this.validateCodeCacheType.getCodeInCache(request, this.getValidateCodeType(), ValidateCode.class, this.redisConnectionFactory);
                if (null != codeInCache && !codeInCache.isExpired()) {
                    throw new SmsCodeRepeatedRequestException(ErrorCodeEnum.SMS_CODE_REPEATED_REQUEST, ip, mobile);
                }
                HttpServletResponse response = request.getResponse();
                if (response == null) {
                    return false;
                }
                boolean result = this.smsCodeSender.sendSms(mobile, validateCode.getCode());
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.OK.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.success((String)"", (Object)validateCode.getExpireIn())));
                return result;
            }
        }
        catch (ServletRequestBindingException e) {
            String msg = String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25-\u624b\u673a\u53f7\u53c2\u6570\u9519\u8bef: error=%s, ip=%s, sid=%s, uri=%s, validateCode=%s", e.getMessage(), ip, sid, uri, validateCode.toString());
            log.error(msg, (Throwable)e);
            throw new ValidateCodeParamErrorException(ErrorCodeEnum.MOBILE_PARAMETER_ERROR, this.validateCodeProperties.getSms().getRequestParamMobileName(), ip);
        }
        catch (PatternSyntaxException e) {
            String msg = String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25-\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e: error=%s, ip=%s, sid=%s, uri=%s, validateCode=%s", e.getMessage(), ip, sid, uri, validateCode.toString());
            log.error(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = String.format("\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f, \u54cd\u5e94\u5931\u8d25: error=%s, ip=%s, sid=%s, uri=%s, validateCode=%s", e.getMessage(), ip, sid, uri, validateCode.toString());
            log.error(msg, (Throwable)e);
        }
        throw new ValidateCodeParamErrorException(ErrorCodeEnum.MOBILE_FORMAT_ERROR, mobile, ip);
    }

    @Override
    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.SMS;
    }
}

