/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.executor.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import top.dcenter.ums.security.core.executor.config.ExecutorPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.executor.properties.ExecutorProperties;

@Configuration
@AutoConfigureAfter(value={ExecutorPropertiesAutoConfiguration.class})
@EnableScheduling
public class ExecutorAutoConfiguration
implements DisposableBean {
    private final ExecutorProperties executorProperties;
    private ScheduledExecutorService jobTaskScheduledExecutor;
    private ExecutorService updateConnectionExecutorService;
    private ExecutorService refreshTokenExecutorService;

    public ExecutorAutoConfiguration(ExecutorProperties executorProperties) {
        this.executorProperties = executorProperties;
    }

    @Bean
    public ScheduledExecutorService jobTaskScheduledExecutor() {
        ExecutorProperties.JobTaskScheduledExecutorProperties jobTaskScheduledExecutor = this.executorProperties.getJobTaskScheduledExecutor();
        MdcScheduledThreadPoolTaskExecutor scheduledThreadPoolExecutor = new MdcScheduledThreadPoolTaskExecutor(jobTaskScheduledExecutor.getCorePoolSize(), this.getThreadFactory(jobTaskScheduledExecutor.getPoolName()), jobTaskScheduledExecutor.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        scheduledThreadPoolExecutor.setKeepAliveTime(jobTaskScheduledExecutor.getKeepAliveTime().intValue(), jobTaskScheduledExecutor.getTimeUnit());
        this.jobTaskScheduledExecutor = scheduledThreadPoolExecutor;
        return scheduledThreadPoolExecutor;
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
    public ExecutorService refreshTokenTaskExecutor() {
        ExecutorProperties.RefreshTokenExecutorProperties refreshToken = this.executorProperties.getRefreshToken();
        MdcThreadPoolTaskExecutor threadPoolExecutor = new MdcThreadPoolTaskExecutor(refreshToken.getCorePoolSize(), refreshToken.getMaximumPoolSize(), refreshToken.getKeepAliveTime().intValue(), refreshToken.getTimeUnit(), new LinkedBlockingQueue<Runnable>(refreshToken.getBlockingQueueCapacity()), this.getThreadFactory(refreshToken.getPoolName()), refreshToken.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.refreshTokenExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
    public ExecutorService updateConnectionTaskExecutor() {
        ExecutorProperties.UserConnectionUpdateExecutorProperties userConnectionUpdate = this.executorProperties.getUserConnectionUpdate();
        MdcThreadPoolTaskExecutor threadPoolExecutor = new MdcThreadPoolTaskExecutor(userConnectionUpdate.getCorePoolSize(), userConnectionUpdate.getMaximumPoolSize(), userConnectionUpdate.getKeepAliveTime().intValue(), userConnectionUpdate.getTimeUnit(), new LinkedBlockingQueue<Runnable>(userConnectionUpdate.getBlockingQueueCapacity()), this.getThreadFactory(userConnectionUpdate.getPoolName()), userConnectionUpdate.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.updateConnectionExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    private ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    public void shutdown() throws Exception {
        if (this.updateConnectionExecutorService != null) {
            this.updateConnectionExecutorService.shutdown();
            this.updateConnectionExecutorService.awaitTermination(this.executorProperties.getUserConnectionUpdate().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.updateConnectionExecutorService.isTerminated()) {
                this.updateConnectionExecutorService.shutdownNow();
            }
        }
    }

    public void destroy() throws Exception {
        if (this.refreshTokenExecutorService != null) {
            this.refreshTokenExecutorService.shutdown();
            this.refreshTokenExecutorService.awaitTermination(this.executorProperties.getJobTaskScheduledExecutor().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.refreshTokenExecutorService.isTerminated()) {
                this.refreshTokenExecutorService.shutdownNow();
            }
        }
        if (this.jobTaskScheduledExecutor != null) {
            this.jobTaskScheduledExecutor.shutdown();
            this.jobTaskScheduledExecutor.awaitTermination(this.executorProperties.getJobTaskScheduledExecutor().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.jobTaskScheduledExecutor.isTerminated()) {
                this.jobTaskScheduledExecutor.shutdownNow();
            }
        }
    }

    private static class MdcThreadPoolTaskExecutor
    extends ThreadPoolExecutor {
        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        public void execute(@NonNull Runnable runnable) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(runnable, context);
            super.execute(r);
        }

        @Override
        @NonNull
        public Future<?> submit(@NonNull Runnable task) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(task, context);
            return super.submit(r);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(@NonNull Callable<T> task) {
            Map context = MDC.getCopyOfContextMap();
            Callable<T> c = this.decorateCallable(task, context);
            return super.submit(c);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(Runnable task, T result) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(task, context);
            return super.submit(r, result);
        }

        @Override
        @NonNull
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        private void run(Runnable runnable, Map<String, String> context) {
            if (context != null) {
                MDC.setContextMap(context);
            }
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> V call(Callable<V> task, Map<String, String> context) throws Exception {
            if (context != null) {
                MDC.setContextMap(context);
            }
            try {
                V v = task.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        }

        private Runnable decorateRunnable(Runnable runnable, Map<String, String> context) {
            return () -> this.run(runnable, context);
        }

        private <V> Callable<V> decorateCallable(Callable<V> task, Map<String, String> context) {
            return () -> this.call(task, context);
        }
    }

    private static class MdcScheduledThreadPoolTaskExecutor
    extends ScheduledThreadPoolExecutor {
        ThreadLocal<Boolean> isMdcInit = new ThreadLocal();

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize, RejectedExecutionHandler handler) {
            super(corePoolSize, handler);
        }

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        @Override
        @NonNull
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(command, context);
            return super.schedule(r, delay, unit);
        }

        @Override
        @NonNull
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Callable<V> c = this.decorateCallable(callable, context);
            return super.schedule(c, delay, unit);
        }

        @Override
        @NonNull
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(command, context);
            return super.scheduleAtFixedRate(r, initialDelay, period, unit);
        }

        @Override
        @NonNull
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(command, context);
            return super.scheduleWithFixedDelay(r, initialDelay, delay, unit);
        }

        @Override
        public void execute(Runnable command) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(command, context);
            super.execute(r);
        }

        @Override
        @NonNull
        public Future<?> submit(Runnable task) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(task, context);
            return super.submit(r);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(Runnable task, T result) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = this.decorateRunnable(task, context);
            return super.submit(r, result);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(Callable<T> task) {
            Map context = MDC.getCopyOfContextMap();
            Callable<T> c = this.decorateCallable(task, context);
            return super.submit(c);
        }

        @Override
        @NonNull
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.decorateCallable((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        private void run(Runnable runnable, Map<String, String> context) {
            if (context != null) {
                MDC.setContextMap(context);
            }
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> V call(Callable<V> task, Map<String, String> context) throws Exception {
            if (context != null) {
                MDC.setContextMap(context);
            }
            try {
                V v = task.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        }

        private Runnable decorateRunnable(Runnable runnable, Map<String, String> context) {
            return () -> this.run(runnable, context);
        }

        private <V> Callable<V> decorateCallable(Callable<V> task, Map<String, String> context) {
            return () -> this.call(task, context);
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

