/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.jackson2.jwt.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collection;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class BearerTokenAuthenticationDeserializer
extends StdDeserializer<BearerTokenAuthentication> {
    public BearerTokenAuthenticationDeserializer() {
        super(BearerTokenAuthentication.class);
    }

    public BearerTokenAuthentication deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        Collection tokenAuthorities = (Collection)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Collection<SimpleGrantedAuthority>>(){});
        JsonNode detailsNode = jsonNode.get("details");
        JsonNode principalNode = jsonNode.get("principal");
        JsonNode tokenNode = jsonNode.get("token");
        JavaType tokenJavaType = mapper.getTypeFactory().constructType(OAuth2AccessToken.class);
        OAuth2AccessToken token = (OAuth2AccessToken)mapper.convertValue((Object)tokenNode, tokenJavaType);
        JavaType principalJavaType = mapper.getTypeFactory().constructType(OAuth2AuthenticatedPrincipal.class);
        OAuth2AuthenticatedPrincipal principal = (OAuth2AuthenticatedPrincipal)mapper.convertValue((Object)principalNode, principalJavaType);
        BearerTokenAuthentication bearerToken = new BearerTokenAuthentication(principal, token, tokenAuthorities);
        bearerToken.eraseCredentials();
        if (!detailsNode.isNull() && !detailsNode.isMissingNode()) {
            WebAuthenticationDetails details = (WebAuthenticationDetails)mapper.convertValue((Object)detailsNode, (TypeReference)new TypeReference<WebAuthenticationDetails>(){});
            bearerToken.setDetails((Object)details);
        }
        return bearerToken;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=BearerTokenAuthenticationDeserializer.class)
    public static interface BearerTokenAuthenticationMixin {
    }
}

