/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.jackson2.jwt.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;

public class BearerTokenAuthenticationTokenDeserializer
extends StdDeserializer<BearerTokenAuthenticationToken> {
    public BearerTokenAuthenticationTokenDeserializer() {
        super(BearerTokenAuthenticationToken.class);
    }

    public BearerTokenAuthenticationToken deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        String token = jsonNode.get("token").asText(null);
        BearerTokenAuthenticationToken bearerToken = new BearerTokenAuthenticationToken(token);
        bearerToken.eraseCredentials();
        return bearerToken;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=BearerTokenAuthenticationTokenDeserializer.class)
    public static interface BearerTokenAuthenticationTokenMixin {
    }
}

