/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.jackson2.jwt.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import top.dcenter.ums.security.common.utils.JsonUtil;

public class DefaultOAuth2AuthenticatedPrincipalDeserializer
extends StdDeserializer<DefaultOAuth2AuthenticatedPrincipal> {
    public DefaultOAuth2AuthenticatedPrincipalDeserializer() {
        super(DefaultOAuth2AuthenticatedPrincipal.class);
    }

    public DefaultOAuth2AuthenticatedPrincipal deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<SimpleGrantedAuthority> authorities;
        JsonNode jsonNode;
        ObjectMapper mapper;
        block5: {
            mapper = (ObjectMapper)p.getCodec();
            jsonNode = (JsonNode)mapper.readTree(p);
            JsonNode authoritiesNode = jsonNode.get("authorities");
            try {
                ArrayList<SimpleGrantedAuthority> tempAuthorities;
                authorities = tempAuthorities = (ArrayList<SimpleGrantedAuthority>)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Collection<SimpleGrantedAuthority>>(){});
            }
            catch (Exception e) {
                String authoritiesString = authoritiesNode.toString();
                String prefix = "[\"java.util.Collections$UnmodifiableCollection\",";
                if (authoritiesString.startsWith(prefix)) {
                    authoritiesString = authoritiesString.substring(prefix.length());
                    int cutLen = 2;
                    if (authoritiesString.length() == 3) {
                        cutLen = 1;
                    }
                    authoritiesString = authoritiesString.substring(0, authoritiesString.length() - cutLen);
                }
                String prefix2 = "\\[\"org\\.springframework\\.security\\.core\\.authority\\.SimpleGrantedAuthority\",";
                authoritiesString = authoritiesString.replaceAll(prefix2, "");
                authoritiesString = authoritiesString.replaceAll("],", ",");
                List list = (List)JsonUtil.json2Object((String)authoritiesString, ArrayList.class);
                authorities = new ArrayList<SimpleGrantedAuthority>();
                if (!Objects.nonNull(list)) break block5;
                for (LinkedHashMap map : list) {
                    authorities.add(new SimpleGrantedAuthority((String)map.get("authority")));
                }
            }
        }
        JsonNode attributesNode = jsonNode.get("attributes");
        String name = jsonNode.get("name").asText(null);
        Map attributes = (Map)mapper.readValue(attributesNode.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        DefaultOAuth2AuthenticatedPrincipal principal = Objects.nonNull(name) ? new DefaultOAuth2AuthenticatedPrincipal(name, attributes, authorities) : new DefaultOAuth2AuthenticatedPrincipal(attributes, authorities);
        return principal;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=DefaultOAuth2AuthenticatedPrincipalDeserializer.class)
    public static interface DefaultOAuth2AuthenticatedPrincipalMixin {
    }
}

