/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.jackson2.jwt.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import top.dcenter.ums.security.common.utils.JsonUtil;

public class JwtAuthenticationTokenDeserializer
extends StdDeserializer<JwtAuthenticationToken> {
    public JwtAuthenticationTokenDeserializer() {
        super(JwtAuthenticationToken.class);
    }

    public JwtAuthenticationToken deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        Collection tokenAuthorities = (Collection)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Collection<SimpleGrantedAuthority>>(){});
        boolean authenticated = jsonNode.get("authenticated").asBoolean();
        JsonNode detailsNode = jsonNode.get("details");
        String name = jsonNode.get("name").asText(null);
        JsonNode tokenNode = jsonNode.get("token");
        Object jwt = JsonUtil.getObject((ObjectMapper)mapper, (JsonNode)tokenNode);
        JwtAuthenticationToken token = authenticated ? (Objects.nonNull(name) ? new JwtAuthenticationToken((Jwt)jwt, tokenAuthorities, name) : new JwtAuthenticationToken((Jwt)jwt, tokenAuthorities)) : new JwtAuthenticationToken((Jwt)jwt);
        token.eraseCredentials();
        if (!detailsNode.isNull() && !detailsNode.isMissingNode()) {
            WebAuthenticationDetails details = (WebAuthenticationDetails)mapper.convertValue((Object)detailsNode, (TypeReference)new TypeReference<WebAuthenticationDetails>(){});
            token.setDetails((Object)details);
        }
        return token;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=JwtAuthenticationTokenDeserializer.class)
    public static interface JwtAuthenticationTokenMixin {
    }
}

