/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.jackson.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collection;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.core.oauth.token.Auth2AuthenticationToken;

public class Auth2AuthenticationTokenJsonDeserializer
extends StdDeserializer<Auth2AuthenticationToken> {
    public Auth2AuthenticationTokenJsonDeserializer() {
        super(Auth2AuthenticationToken.class);
    }

    public Auth2AuthenticationToken deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        Collection tokenAuthorities = (Collection)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Collection<SimpleGrantedAuthority>>(){});
        boolean authenticated = jsonNode.get("authenticated").asBoolean();
        String providerId = jsonNode.get("providerId").asText(null);
        JsonNode detailsNode = jsonNode.get("details");
        JsonNode principalNode = jsonNode.get("principal");
        Object principal = JsonUtil.getObject((ObjectMapper)mapper, (JsonNode)principalNode);
        Auth2AuthenticationToken auth2AuthenticationToken = new Auth2AuthenticationToken(principal, tokenAuthorities, providerId);
        auth2AuthenticationToken.setAuthenticated(authenticated);
        WebAuthenticationDetails details = (WebAuthenticationDetails)mapper.convertValue((Object)detailsNode, (TypeReference)new TypeReference<WebAuthenticationDetails>(){});
        auth2AuthenticationToken.setDetails(details);
        return auth2AuthenticationToken;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=Auth2AuthenticationTokenJsonDeserializer.class)
    public static interface Auth2AuthenticationTokenMixin {
    }
}

