/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.tasks.config;

import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import top.dcenter.ums.security.core.api.mdc.MdcIdGenerator;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.mdc.MdcIdType;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.tasks.config.TasksAutoConfiguration;
import top.dcenter.ums.security.core.tasks.handler.RefreshAccessTokenJobHandler;
import top.dcenter.ums.security.core.tasks.handler.RefreshValidateCodeCacheJobHandler;

@Configuration
@AutoConfigureAfter(value={TasksAutoConfiguration.class})
@EnableScheduling
public class ScheduleAutoConfiguration
implements SchedulingConfigurer {
    private final ScheduledExecutorService jobTaskScheduledExecutor;
    private final Auth2Properties auth2Properties;
    private final ValidateCodeProperties validateCodeProperties;
    private final RefreshValidateCodeCacheJobHandler refreshValidateCodeCacheJobHandler;
    private final RefreshAccessTokenJobHandler refreshAccessTokenJobHandler;
    private final MdcIdType mdcIdType;
    @Autowired(required=false)
    private MdcIdGenerator mdcIdGenerator;

    public ScheduleAutoConfiguration(@Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor, Auth2Properties auth2Properties, ValidateCodeProperties validateCodeProperties, MdcProperties mdcProperties, @Autowired(required=false) RefreshValidateCodeCacheJobHandler refreshValidateCodeCacheJobHandler, @Autowired(required=false) RefreshAccessTokenJobHandler refreshAccessTokenJobHandler) {
        this.jobTaskScheduledExecutor = jobTaskScheduledExecutor;
        this.auth2Properties = auth2Properties;
        this.validateCodeProperties = validateCodeProperties;
        this.refreshValidateCodeCacheJobHandler = refreshValidateCodeCacheJobHandler;
        this.refreshAccessTokenJobHandler = refreshAccessTokenJobHandler;
        this.mdcIdType = mdcProperties.getType();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.jobTaskScheduledExecutor);
        if (this.refreshAccessTokenJobHandler != null) {
            taskRegistrar.addCronTask(MdcUtil.decorateTasks(this.refreshAccessTokenJobHandler::refreshAccessTokenJob, (MdcIdType)this.mdcIdType, (MdcIdGenerator)this.mdcIdGenerator), this.auth2Properties.getRefreshTokenJobCron());
        }
        if (this.refreshValidateCodeCacheJobHandler != null) {
            taskRegistrar.addCronTask(MdcUtil.decorateTasks(this.refreshValidateCodeCacheJobHandler::refreshValidateCodeJob, (MdcIdType)this.mdcIdType, (MdcIdGenerator)this.mdcIdGenerator), this.validateCodeProperties.getRefreshValidateCodeJobCron());
        }
    }
}

