/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.redis.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.redis.cache.RedisHashCache;
import top.dcenter.ums.security.core.redis.cache.RedisHashCacheWriter;

public class RedisHashCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final RedisHashCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;
    private final boolean allowInFlightCacheCreation;

    private RedisHashCacheManager(RedisHashCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
        this.allowInFlightCacheCreation = allowInFlightCacheCreation;
    }

    public RedisHashCacheManager(RedisHashCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        this(cacheWriter, defaultCacheConfiguration, true);
    }

    public RedisHashCacheManager(RedisHashCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, true, initialCacheNames);
    }

    public RedisHashCacheManager(RedisHashCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        for (String cacheName : initialCacheNames) {
            this.initialCacheConfiguration.put(cacheName, defaultCacheConfiguration);
        }
    }

    public RedisHashCacheManager(RedisHashCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, true);
    }

    public RedisHashCacheManager(RedisHashCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        Assert.notNull(initialCacheConfigurations, (String)"InitialCacheConfigurations must not be null!");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    public static RedisHashCacheManager create(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return new RedisHashCacheManager(new RedisHashCacheWriter(connectionFactory), RedisCacheConfiguration.defaultCacheConfig());
    }

    public static RedisHashCacheManagerBuilder builder() {
        return new RedisHashCacheManagerBuilder();
    }

    public static RedisHashCacheManagerBuilder builder(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return RedisHashCacheManagerBuilder.fromConnectionFactory(connectionFactory);
    }

    public static RedisHashCacheManagerBuilder builder(RedisHashCacheWriter cacheWriter) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        return RedisHashCacheManagerBuilder.fromCacheWriter(cacheWriter);
    }

    @NonNull
    protected Collection<RedisCache> loadCaches() {
        LinkedList<RedisCache> caches = new LinkedList<RedisCache>();
        for (Map.Entry<String, RedisCacheConfiguration> entry : this.initialCacheConfiguration.entrySet()) {
            caches.add(this.createRedisCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    protected RedisCache getMissingCache(@NonNull String name) {
        return this.allowInFlightCacheCreation ? this.createRedisCache(name, this.defaultCacheConfig) : null;
    }

    public Map<String, RedisCacheConfiguration> getCacheConfigurations() {
        HashMap configurationMap = new HashMap(this.getCacheNames().size());
        this.getCacheNames().forEach(it -> {
            RedisCache cache = (RedisCache)RedisCache.class.cast(this.lookupCache((String)it));
            configurationMap.put(it, cache != null ? cache.getCacheConfiguration() : null);
        });
        return Collections.unmodifiableMap(configurationMap);
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        return new RedisHashCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }

    public static class RedisHashCacheManagerBuilder {
        private RedisHashCacheWriter cacheWriter;
        private RedisCacheConfiguration defaultCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        private final Map<String, RedisCacheConfiguration> initialCaches = new LinkedHashMap<String, RedisCacheConfiguration>();
        private boolean enableTransactions;
        boolean allowInFlightCacheCreation = true;

        private RedisHashCacheManagerBuilder() {
        }

        private RedisHashCacheManagerBuilder(@Nullable RedisHashCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public static RedisHashCacheManagerBuilder fromConnectionFactory(RedisConnectionFactory connectionFactory) {
            Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
            return new RedisHashCacheManagerBuilder(new RedisHashCacheWriter(connectionFactory));
        }

        public static RedisHashCacheManagerBuilder fromCacheWriter(RedisHashCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            return new RedisHashCacheManagerBuilder(cacheWriter);
        }

        public RedisHashCacheManagerBuilder cacheDefaults(RedisCacheConfiguration defaultCacheConfiguration) {
            Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
            this.defaultCacheConfiguration = defaultCacheConfiguration;
            return this;
        }

        public RedisHashCacheManagerBuilder cacheWriter(RedisHashCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            this.cacheWriter = cacheWriter;
            return this;
        }

        public RedisHashCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public RedisHashCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            Assert.notNull(cacheNames, (String)"CacheNames must not be null!");
            cacheNames.forEach(it -> this.withCacheConfiguration((String)it, this.defaultCacheConfiguration));
            return this;
        }

        public RedisHashCacheManagerBuilder withInitialCacheConfigurations(Map<String, RedisCacheConfiguration> cacheConfigurations) {
            Assert.notNull(cacheConfigurations, (String)"CacheConfigurations must not be null!");
            cacheConfigurations.forEach((cacheName, configuration) -> Assert.notNull((Object)configuration, (String)String.format("RedisCacheConfiguration for cache %s must not be null!", cacheName)));
            this.initialCaches.putAll(cacheConfigurations);
            return this;
        }

        public RedisHashCacheManagerBuilder withCacheConfiguration(String cacheName, RedisCacheConfiguration cacheConfiguration) {
            Assert.notNull((Object)cacheName, (String)"CacheName must not be null!");
            Assert.notNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null!");
            this.initialCaches.put(cacheName, cacheConfiguration);
            return this;
        }

        public RedisHashCacheManagerBuilder disableCreateOnMissingCache() {
            this.allowInFlightCacheCreation = false;
            return this;
        }

        public Set<String> getConfiguredCaches() {
            return Collections.unmodifiableSet(this.initialCaches.keySet());
        }

        public Optional<RedisCacheConfiguration> getCacheConfigurationFor(String cacheName) {
            return Optional.ofNullable(this.initialCaches.get(cacheName));
        }

        public RedisHashCacheManager build() {
            Assert.state((this.cacheWriter != null ? 1 : 0) != 0, (String)"CacheWriter must not be null! You can provide one via 'RedisCacheManagerBuilder#cacheWriter(RedisHashCacheWriter)'.");
            RedisHashCacheManager cm = new RedisHashCacheManager(this.cacheWriter, this.defaultCacheConfiguration, this.initialCaches, this.allowInFlightCacheCreation);
            cm.setTransactionAware(this.enableTransactions);
            return cm;
        }
    }
}

