/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.auth.config.SmsCodeLoginAutoAuthenticationConfigurer;
import top.dcenter.ums.security.core.auth.properties.SmsCodeLoginAuthenticationProperties;

@Configuration
@ConditionalOnProperty(prefix="ums.mobile.login", name={"sms-code-login-is-open"}, havingValue="true")
@AutoConfigureAfter(value={SmsCodeLoginAutoAuthenticationConfigurer.class})
public class SmsCodeLoginAuthenticationAutoConfigurerAware
implements HttpSecurityAware {
    private static final Logger log = LoggerFactory.getLogger(SmsCodeLoginAuthenticationAutoConfigurerAware.class);
    @Autowired(required=false)
    private SmsCodeLoginAutoAuthenticationConfigurer smsCodeLoginAutoAuthenticationConfigurer;
    private final SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties;

    public SmsCodeLoginAuthenticationAutoConfigurerAware(SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties) {
        this.smsCodeLoginAuthenticationProperties = smsCodeLoginAuthenticationProperties;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) {
    }

    public void preConfigure(HttpSecurity http) throws Exception {
        if (this.smsCodeLoginAutoAuthenticationConfigurer != null) {
            http.apply((SecurityConfigurerAdapter)this.smsCodeLoginAutoAuthenticationConfigurer);
        }
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Object> permitAllMap = new HashMap<UriHttpMethodTuple, Object>(16);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)this.smsCodeLoginAuthenticationProperties.getLoginProcessingUrlMobile()), null);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

