/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.header.Header;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
public class CorsAutoConfigurationAware
implements HttpSecurityAware {
    private final ClientProperties.CorsProperties corsProperties;

    public CorsAutoConfigurationAware(ClientProperties clientProperties) {
        this.corsProperties = clientProperties.getCors();
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) {
    }

    public void preConfigure(HttpSecurity http) {
    }

    public void postConfigure(HttpSecurity http) throws Exception {
        if (this.corsProperties.getEnable().booleanValue()) {
            ((HttpSecurity)http.cors().configurationSource(this.corsConfigurationSource()).and()).headers().addHeaderWriter((HeaderWriter)new StaticHeadersWriter(Arrays.asList(new Header("Access-control-Allow-Origin", this.corsProperties.getAccessControlAllowOrigin().toArray(new String[0])), new Header("Access-Control-Expose-Headers", new String[]{StringUtils.collectionToDelimitedString(this.corsProperties.getAccessControlExposeHeaders(), (String)",")}))));
        } else {
            http.cors().disable();
        }
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        return null;
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Objects.requireNonNull(this.corsProperties.getAccessControlAllowOrigin(), "AccessControlAllowOrigin cannot be null"));
        configuration.setAllowedMethods(Objects.requireNonNull(this.corsProperties.getAccessControlAllowMethods(), "AccessControlAllowMethods cannot be null"));
        configuration.setAllowedHeaders(Objects.requireNonNull(this.corsProperties.getAccessControlAllowHeaders(), "AccessControlAllowHeaders cannot be null"));
        List<String> accessControlExposeHeaders = this.corsProperties.getAccessControlExposeHeaders();
        Objects.requireNonNull(accessControlExposeHeaders, "AccessControlExposeHeaders cannot be null");
        accessControlExposeHeaders.forEach(arg_0 -> ((CorsConfiguration)configuration).addExposedHeader(arg_0));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        Objects.requireNonNull(this.corsProperties.getUrlList(), "urlList cannot be null").forEach(uri -> source.registerCorsConfiguration(uri, configuration));
        return source;
    }
}

