/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.common.propertis.RememberMeProperties;
import top.dcenter.ums.security.common.utils.AppContextUtil;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.api.tenant.handler.TenantContextHolder;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationFilter;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationProvider;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.properties.SmsCodeLoginAuthenticationProperties;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;

@Configuration
@ConditionalOnProperty(prefix="ums.mobile.login", name={"sms-code-login-is-open"}, havingValue="true")
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class SmsCodeLoginAutoAuthenticationConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final ValidateCodeProperties validateCodeProperties;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    @Autowired
    private UmsUserDetailsService userDetailsService;
    @Autowired(required=false)
    private PersistentTokenRepository persistentTokenRepository;
    @Autowired(required=false)
    private TenantContextHolder tenantContextHolder;
    @Autowired(required=false)
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;
    @Autowired(required=false)
    private RememberMeServices rememberMeServices;
    @Autowired(required=false)
    private GenerateClaimsSetService generateClaimsSetService;
    @Autowired
    private ClientProperties clientProperties;
    private final SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties;

    public SmsCodeLoginAutoAuthenticationConfigurer(ValidateCodeProperties validateCodeProperties, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties) {
        this.validateCodeProperties = validateCodeProperties;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
        this.smsCodeLoginAuthenticationProperties = smsCodeLoginAuthenticationProperties;
    }

    public void configure(HttpSecurity http) {
        SmsCodeLoginAuthenticationFilter smsCodeLoginAuthenticationFilter = new SmsCodeLoginAuthenticationFilter(this.validateCodeProperties, this.smsCodeLoginAuthenticationProperties, this.tenantContextHolder, this.authenticationDetailsSource);
        smsCodeLoginAuthenticationFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        AppContextUtil.registerHandlerAndRememberMeServices((AbstractAuthenticationProcessingFilter)smsCodeLoginAuthenticationFilter, (BaseAuthenticationSuccessHandler)this.baseAuthenticationSuccessHandler, (BaseAuthenticationFailureHandler)this.baseAuthenticationFailureHandler, (PersistentTokenRepository)this.persistentTokenRepository, (UmsUserDetailsService)this.userDetailsService, (RememberMeServices)this.rememberMeServices, (RememberMeProperties)this.clientProperties.getRememberMe());
        SmsCodeLoginAuthenticationProvider smsCodeLoginAuthenticationProvider = new SmsCodeLoginAuthenticationProvider(this.userDetailsService, this.generateClaimsSetService);
        http.authenticationProvider((AuthenticationProvider)this.postProcess(smsCodeLoginAuthenticationProvider)).addFilterAfter((Filter)this.postProcess((Object)smsCodeLoginAuthenticationFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }
}

