/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.redisson.config;

import java.io.IOException;
import java.io.InputStream;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import top.dcenter.ums.security.core.redisson.config.RedissonProperties;

@Configuration
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedissonClientAutoConfiguration.class);
    @Autowired
    private RedissonProperties redissonProperties;

    @Bean(destroyMethod="shutdown")
    public RedissonClient redissonClient() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(this.redissonProperties.getConfigFileName());
        Config config = Config.fromYAML((InputStream)classPathResource.getInputStream());
        return Redisson.create((Config)config);
    }
}

