/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.advice;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.exception.AccountDisabledException;
import top.dcenter.ums.security.core.exception.AccountExpiredException;
import top.dcenter.ums.security.core.exception.AccountLockedException;
import top.dcenter.ums.security.core.exception.BusinessException;
import top.dcenter.ums.security.core.exception.CredentialsExpiredException;
import top.dcenter.ums.security.core.exception.ExpiredSessionDetectedException;
import top.dcenter.ums.security.core.exception.IllegalAccessUrlException;
import top.dcenter.ums.security.core.exception.ParameterErrorException;
import top.dcenter.ums.security.core.exception.RegisterUserNotImplementException;
import top.dcenter.ums.security.core.exception.UserNotExistException;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;

@Order(value=100)
@ControllerAdvice
public class SecurityControllerAdviceHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityControllerAdviceHandler.class);

    @ExceptionHandler(value={RegisterUserNotImplementException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult registerUserNotImplementException(RegisterUserNotImplementException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={AbstractResponseJsonAuthenticationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult abstractResponseJsonAuthenticationException(AbstractResponseJsonAuthenticationException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={UsernameNotFoundException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult usernameNotFoundException(UsernameNotFoundException ex) {
        return ResponseResult.fail((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", (ErrorCodeEnum)ErrorCodeEnum.USERNAME_OR_PASSWORD_ERROR, (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={AccountDisabledException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult accountDisabledException(AccountDisabledException ex) {
        String message = ex.getMessage();
        return ResponseResult.fail((String)message, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={AccountExpiredException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult accountExpiredException(AccountExpiredException ex) {
        String message = ex.getMessage();
        return ResponseResult.fail((String)message, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={AccountLockedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult accountLockedException(AccountLockedException ex) {
        String message = ex.getMessage();
        return ResponseResult.fail((String)message, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={CredentialsExpiredException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult credentialsExpiredException(CredentialsExpiredException ex) {
        String message = ex.getMessage();
        return ResponseResult.fail((String)message, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={UserNotExistException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult userNotExistException(UserNotExistException ex) {
        String message = ex.getMessage();
        return ResponseResult.fail((String)message, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={ParameterErrorException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseResult parameterErrorException(ParameterErrorException ex) {
        String message = ex.getMessage();
        return ResponseResult.fail((String)message, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={IllegalAccessUrlException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseResult illegalAccessUrlException(IllegalAccessUrlException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={ExpiredSessionDetectedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult expiredSessionDetectedException(ExpiredSessionDetectedException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult expiredSessionDetectedException(AuthenticationException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ErrorCodeEnum.UNAUTHORIZED, (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseResult businessException(BusinessException e) {
        return ResponseResult.fail((String)e.getMessage(), (ErrorCodeEnum)ErrorCodeEnum.BUSINESS_ERROR, (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseResult handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        return ResponseResult.fail((String)ErrorCodeEnum.PARAMETER_ERROR.getMsg(), (ErrorCodeEnum)ErrorCodeEnum.PARAMETER_ERROR, (Object)MdcUtil.getMdcTraceId());
    }
}

