/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.ReflectionUtil;
import top.dcenter.ums.security.core.api.controller.BaseSecurityController;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.exception.IllegalAccessUrlException;

@Api(value="\u767b\u5f55\u8def\u7531\u63a7\u5236")
@ResponseBody
public class ClientSecurityController
implements BaseSecurityController,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ClientSecurityController.class);
    public static final String URL_REGEX = "^.*://[^/]*(/.*$)";
    public static final String URI_$1 = "$1";
    private final RequestCache requestCache;
    private final RedirectStrategy redirectStrategy;
    private final ClientProperties clientProperties;
    private final AntPathMatcher pathMatcher;
    private final Map<String, String> authRedirectUrls;
    @Autowired
    private GenericApplicationContext applicationContext;

    public ClientSecurityController(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.requestCache = new HttpSessionRequestCache();
        this.redirectStrategy = new DefaultRedirectStrategy();
        this.authRedirectUrls = clientProperties.getAuthRedirectSuffixCondition().stream().map(pair -> pair.split("=")).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
        this.pathMatcher = new AntPathMatcher();
    }

    @Override
    @ApiOperation(value="\u767b\u5f55\u8def\u7531\u63a7\u5236", notes="\u8bbe\u7f6e uri \u76f8\u5bf9\u5e94\u7684\u8df3\u8f6c\u767b\u5f55\u9875, \u4f8b\u5982\uff1akey=/**: value=/login.html, \u7528\u7b49\u53f7\u9694\u5f00key\u4e0evalue, \u5982: /**=/login.html, \u9ed8\u8ba4\u4e3a\u7a7a.\n\u652f\u6301\u901a\u914d\u7b26, \u5339\u914d\u89c4\u5219\uff1a /user/aa/bb/cc.html \u5339\u914d pattern\uff1a/us?r/**/*.html, /user/**, /user/*/bb/c?.html, /user/**/*.*.\n\u89c4\u5219\u5177\u4f53\u770b AntPathMatcher.match(pattern, path)", httpMethod="GET")
    @RequestMapping(value={"/authentication/require"}, method={RequestMethod.GET})
    public void requireAuthentication(HttpServletRequest request, HttpServletResponse response) {
        try {
            String targetUrl;
            SavedRequest savedRequest = this.requestCache.getRequest(request, response);
            if (savedRequest != null && StringUtils.hasText((String)(targetUrl = savedRequest.getRedirectUrl()))) {
                targetUrl = targetUrl.replaceFirst(URL_REGEX, URI_$1);
                String contextPath = request.getServletContext().getContextPath();
                targetUrl = targetUrl.substring(contextPath.length());
                for (Map.Entry<String, String> entry : this.authRedirectUrls.entrySet()) {
                    if (!this.pathMatcher.match(entry.getKey(), targetUrl)) continue;
                    this.redirectStrategy.sendRedirect(request, response, entry.getValue());
                    return;
                }
            }
            this.redirectStrategy.sendRedirect(request, response, this.clientProperties.getLoginPage());
        }
        catch (Exception e) {
            String requestUri = request.getRequestURI();
            String ip = IpUtil.getRealIp((HttpServletRequest)request);
            String msg = String.format("IllegalAccessUrlException: ip=%s, uri=%s, sid=%s, error=%s", ip, requestUri, request.getSession(true).getId(), e.getMessage());
            log.error(msg, (Throwable)e);
            throw new IllegalAccessUrlException(ErrorCodeEnum.SERVER_ERROR, requestUri, ip);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.clientProperties.getOpenAuthenticationRedirect().booleanValue()) {
            String methodName = "requireAuthentication";
            ReflectionUtil.setRequestMappingUri((String)methodName, (String)this.clientProperties.getLoginUnAuthenticationRoutingUrl(), this.getClass(), (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
            ReflectionUtil.registerController((String)"clientSecurityController", (GenericApplicationContext)this.applicationContext, BaseSecurityController.class);
        }
    }
}

