/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.jackson.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collection;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationToken;

public class SmsCodeLoginAuthenticationTokenJsonDeserializer
extends StdDeserializer<SmsCodeLoginAuthenticationToken> {
    public SmsCodeLoginAuthenticationTokenJsonDeserializer() {
        super(SmsCodeLoginAuthenticationToken.class);
    }

    public SmsCodeLoginAuthenticationToken deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        Collection tokenAuthorities = (Collection)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Collection<SimpleGrantedAuthority>>(){});
        boolean authenticated = jsonNode.get("authenticated").asBoolean();
        JsonNode detailsNode = jsonNode.get("details");
        JsonNode principalNode = jsonNode.get("principal");
        Object principal = JsonUtil.getObject((ObjectMapper)mapper, (JsonNode)principalNode);
        SmsCodeLoginAuthenticationToken token = authenticated ? new SmsCodeLoginAuthenticationToken(principal, tokenAuthorities) : new SmsCodeLoginAuthenticationToken(principal.toString());
        token.eraseCredentials();
        if (!detailsNode.isNull() && !detailsNode.isMissingNode()) {
            WebAuthenticationDetails details = (WebAuthenticationDetails)mapper.convertValue((Object)detailsNode, (TypeReference)new TypeReference<WebAuthenticationDetails>(){});
            token.setDetails(details);
        }
        return token;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=SmsCodeLoginAuthenticationTokenJsonDeserializer.class)
    public static interface SmsCodeLoginAuthenticationTokenMixin {
    }
}

