/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.mobile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.tenant.handler.TenantContextHolder;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationToken;
import top.dcenter.ums.security.core.auth.properties.SmsCodeLoginAuthenticationProperties;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.exception.LoginFailureException;

public class SmsCodeLoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger log = LoggerFactory.getLogger(SmsCodeLoginAuthenticationFilter.class);
    private String mobileParameter;
    private boolean postOnly = true;
    private final ValidateCodeProperties validateCodeProperties;
    private final TenantContextHolder tenantContextHolder;

    public SmsCodeLoginAuthenticationFilter(@NonNull ValidateCodeProperties validateCodeProperties, @NonNull SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties, @Nullable TenantContextHolder tenantContextHolder, @Nullable AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        super((RequestMatcher)new AntPathRequestMatcher(smsCodeLoginAuthenticationProperties.getLoginProcessingUrlMobile(), "POST"));
        this.validateCodeProperties = validateCodeProperties;
        this.mobileParameter = validateCodeProperties.getSms().getRequestParamMobileName();
        this.tenantContextHolder = tenantContextHolder;
        if (authenticationDetailsSource != null) {
            this.setAuthenticationDetailsSource(authenticationDetailsSource);
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String mobile = this.obtainMobile(request);
        if (StringUtils.isEmpty((Object)mobile)) {
            throw new LoginFailureException(ErrorCodeEnum.MOBILE_NOT_EMPTY, this.validateCodeProperties.getSms().getRequestParamMobileName(), request.getSession(true).getId());
        }
        if (this.tenantContextHolder != null) {
            this.tenantContextHolder.tenantIdHandle(request, null);
        }
        mobile = mobile.trim();
        SmsCodeLoginAuthenticationToken authRequest = new SmsCodeLoginAuthenticationToken(mobile);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected String obtainMobile(HttpServletRequest request) {
        return request.getParameter(this.mobileParameter);
    }

    protected void setDetails(HttpServletRequest request, SmsCodeLoginAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setMobileParameter(String mobileParameter) {
        Assert.hasText((String)mobileParameter, (String)"Username parameter must not be empty or null");
        this.mobileParameter = mobileParameter;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public final String getMobileParameter() {
        return this.mobileParameter;
    }
}

